/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public abstract class CreateClassActionBase
extends Intention {
    private final GrCreateClassKind myType;
    protected final GrReferenceElement myRefElement;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase");

    public CreateClassActionBase(GrCreateClassKind type, GrReferenceElement refElement) {
        this.myType = type;
        this.myRefElement = refElement;
    }

    @Override
    @NotNull
    public String getText() {
        String referenceName = this.myRefElement.getReferenceName();
        switch (this.getType()) {
            case TRAIT: {
                String string = GroovyBundle.message("create.trait", referenceName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getText"));
                }
                return string;
            }
            case ENUM: {
                String string = GroovyBundle.message("create.enum", referenceName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getText"));
                }
                return string;
            }
            case CLASS: {
                String string = GroovyBundle.message("create.class.text", referenceName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getText"));
                }
                return string;
            }
            case INTERFACE: {
                String string = GroovyBundle.message("create.interface.text", referenceName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getText"));
                }
                return string;
            }
            case ANNOTATION: {
                String string = GroovyBundle.message("create.annotation.text", referenceName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getText"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getText"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.class.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "isAvailable"));
        }
        return this.myRefElement.isValid() && ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myRefElement) != null;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    protected GrCreateClassKind getType() {
        return this.myType;
    }

    @Nullable
    public static GrTypeDefinition createClassByType(@NotNull PsiDirectory directory, @NotNull String name, @NotNull PsiManager manager, @Nullable PsiElement contextElement, @NotNull String templateName, boolean allowReformatting) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "createClassByType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "createClassByType"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "createClassByType"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "createClassByType"));
        }
        return (GrTypeDefinition)WriteAction.compute(() -> {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "lambda$createClassByType$1"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "lambda$createClassByType$1"));
            }
            if (templateName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "lambda$createClassByType$1"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "lambda$createClassByType$1"));
            }
            try {
                GrTypeDefinition targetClass = null;
                try {
                    PsiFile file = GroovyTemplatesFactory.createFromTemplate(directory, name, name + ".groovy", templateName, allowReformatting, new String[0]);
                    for (PsiElement element : file.getChildren()) {
                        if (!(element instanceof GrTypeDefinition)) continue;
                        targetClass = (GrTypeDefinition)element;
                        break;
                    }
                    if (targetClass == null) {
                        throw new IncorrectOperationException(GroovyBundle.message("no.class.in.file.template", new Object[0]));
                    }
                }
                catch (IncorrectOperationException e) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (name == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "lambda$null$0"));
                        }
                        Messages.showErrorDialog((String)GroovyBundle.message("cannot.create.class.error.text", name, e.getLocalizedMessage()), (String)GroovyBundle.message("cannot.create.class.error.title", new Object[0]));
                    });
                    return null;
                }
                GrModifierList modifiers = targetClass.getModifierList();
                if (contextElement != null && !JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper().isAccessible((PsiMember)targetClass, contextElement, null) && modifiers != null) {
                    modifiers.setModifierProperty("public", true);
                }
                return targetClass;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        });
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(@NotNull Project project, @NotNull String qualifier, @NotNull String name, @Nullable Module module, @NotNull String title) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getTargetDirectory"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getTargetDirectory"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getTargetDirectory"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getTargetDirectory"));
        }
        CreateClassDialog dialog = new CreateClassDialog(project, title, name, qualifier, this.getType(), false, module){

            protected boolean reportBaseInSourceSelectionInTest() {
                return true;
            }
        };
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog.getTargetDirectory();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase$2", "satisfiedBy"));
                }
                return CreateClassActionBase.this.myRefElement.isValid();
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

