/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveElementQuickFix
implements LocalQuickFix {
    private final String myName;
    private final Function<PsiElement, PsiElement> myElementFunction;

    public RemoveElementQuickFix(@NotNull String name, @NotNull Function<PsiElement, PsiElement> function) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/codeInspection/fixes/RemoveElementQuickFix", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/plugins/groovy/codeInspection/fixes/RemoveElementQuickFix", "<init>"));
        }
        this.myName = name;
        this.myElementFunction = function;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/fixes/RemoveElementQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/fixes/RemoveElementQuickFix", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/fixes/RemoveElementQuickFix", "applyFix"));
        }
        PsiElement descriptorElement = descriptor2.getPsiElement();
        if (descriptorElement == null) {
            return;
        }
        PsiElement elementToRemove = (PsiElement)this.myElementFunction.fun((Object)descriptorElement);
        if (elementToRemove == null) {
            return;
        }
        elementToRemove.delete();
    }
}

