/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathsList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.BuildAndRestartConsoleAction;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtil;
import org.jetbrains.plugins.groovy.console.GroovyConsoleView;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GroovyConsole {
    public static final Key<GroovyConsole> GROOVY_CONSOLE = Key.create((String)"Groovy console key");
    private static final Logger LOG = Logger.getInstance(GroovyConsole.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
    private final Project myProject;
    private final RunContentDescriptor myContentDescriptor;
    private final ConsoleView myConsoleView;
    private final ProcessHandler myProcessHandler;

    public GroovyConsole(Project project, RunContentDescriptor descriptor2, ConsoleView view, ProcessHandler handler) {
        this.myProject = project;
        this.myContentDescriptor = descriptor2;
        this.myConsoleView = view;
        this.myProcessHandler = handler;
    }

    private void doExecute(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/console/GroovyConsole", "doExecute"));
        }
        for (String line : command.trim().split("\n")) {
            this.myConsoleView.print("> ", ConsoleViewContentType.USER_INPUT);
            this.myConsoleView.print(line, ConsoleViewContentType.USER_INPUT);
            this.myConsoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/console/GroovyConsole", "lambda$doExecute$0"));
            }
            GroovyConsole.send(this.myProcessHandler, StringUtil.replace((String)command, (String)"\n", (String)"###\\n"));
        });
    }

    public void execute(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/console/GroovyConsole", "execute"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)command)) {
            this.doExecute(command);
        }
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().toFrontRunContent(defaultExecutor, this.myContentDescriptor);
    }

    public void stop() {
        this.myProcessHandler.destroyProcess();
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().removeRunContent(defaultExecutor, this.myContentDescriptor);
    }

    private static void send(@NotNull ProcessHandler processHandler, @NotNull String command) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/plugins/groovy/console/GroovyConsole", "send"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/console/GroovyConsole", "send"));
        }
        OutputStream outputStream = processHandler.getProcessInput();
        assert (outputStream != null) : "output stream is null";
        Charset charset = processHandler instanceof BaseOSProcessHandler ? ((BaseOSProcessHandler)processHandler).getCharset() : null;
        byte[] bytes = (command + "\n").getBytes(charset != null ? charset : UTF_8);
        try {
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException ignored) {
            LOG.warn((Throwable)ignored);
        }
    }

    public static void getOrCreateConsole(@NotNull Project project, @NotNull VirtualFile contentFile, @NotNull Consumer<GroovyConsole> callback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/GroovyConsole", "getOrCreateConsole"));
        }
        if (contentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFile", "org/jetbrains/plugins/groovy/console/GroovyConsole", "getOrCreateConsole"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/plugins/groovy/console/GroovyConsole", "getOrCreateConsole"));
        }
        GroovyConsole existingConsole = (GroovyConsole)contentFile.getUserData(GROOVY_CONSOLE);
        if (existingConsole != null) {
            return;
        }
        Consumer initializer = module -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/GroovyConsole", "lambda$getOrCreateConsole$1"));
            }
            if (contentFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFile", "org/jetbrains/plugins/groovy/console/GroovyConsole", "lambda$getOrCreateConsole$1"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/plugins/groovy/console/GroovyConsole", "lambda$getOrCreateConsole$1"));
            }
            GroovyConsole console = GroovyConsole.createConsole(project, contentFile, module);
            if (console != null) {
                callback.consume((Object)console);
            }
        };
        Module module2 = GroovyConsoleStateService.getInstance(project).getSelectedModule(contentFile);
        if (module2 == null || module2.isDisposed()) {
            GroovyConsoleUtil.selectModuleAndRun(project, (Consumer<Module>)initializer);
        } else {
            initializer.consume((Object)module2);
        }
    }

    @Nullable
    public static GroovyConsole createConsole(@NotNull Project project, final @NotNull VirtualFile contentFile, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/GroovyConsole", "createConsole"));
        }
        if (contentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFile", "org/jetbrains/plugins/groovy/console/GroovyConsole", "createConsole"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyConsole", "createConsole"));
        }
        final ProcessHandler processHandler = GroovyConsole.createProcessHandler(module);
        if (processHandler == null) {
            return null;
        }
        GroovyConsoleStateService consoleStateService = GroovyConsoleStateService.getInstance(project);
        consoleStateService.setFileModule(contentFile, module);
        String title = consoleStateService.getSelectedModuleTitle(contentFile);
        GroovyConsoleView consoleView = new GroovyConsoleView(project);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, processHandler, (JComponent)new JPanel(new BorderLayout()), title);
        final GroovyConsole console = new GroovyConsole(project, descriptor2, (ConsoleView)consoleView, processHandler);
        JComponent consoleViewComponent = consoleView.getComponent();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new BuildAndRestartConsoleAction(module, project, defaultExecutor, descriptor2, GroovyConsole.restarter(project, contentFile)));
        actionGroup.addSeparator();
        actionGroup.addAll(consoleView.createConsoleActions());
        actionGroup.add((AnAction)new CloseAction(defaultExecutor, descriptor2, project){

            public void actionPerformed(AnActionEvent e) {
                processHandler.destroyProcess();
                super.actionPerformed(e);
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("GroovyConsole", (ActionGroup)actionGroup, false);
        toolbar.setTargetComponent(consoleViewComponent);
        JComponent ui = descriptor2.getComponent();
        ui.add((Component)consoleViewComponent, "Center");
        ui.add((Component)toolbar.getComponent(), "West");
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/groovy/console/GroovyConsole$2", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/console/GroovyConsole$2", "fileClosed"));
                }
                if (file.equals(contentFile)) {
                    console.stop();
                }
            }
        });
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                if (contentFile.getUserData(GROOVY_CONSOLE) == console) {
                    contentFile.putUserData(GROOVY_CONSOLE, null);
                }
            }
        });
        contentFile.putUserData(GROOVY_CONSOLE, (Object)console);
        consoleView.attachToProcess(processHandler);
        processHandler.startNotify();
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(defaultExecutor, descriptor2);
        return console;
    }

    private static ProcessHandler createProcessHandler(Module module) {
        try {
            JavaParameters javaParameters = GroovyConsole.createJavaParameters(module);
            GeneralCommandLine commandLine = javaParameters.toCommandLine();
            return new OSProcessHandler(commandLine){

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static JavaParameters createJavaParameters(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyConsole", "createJavaParameters"));
        }
        JavaParameters res = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(res, module, "groovy.ui.GroovyMain", !GroovyConsoleUtil.hasGroovyAll(module), true);
        PathsList list = GroovyScriptRunner.getClassPathFromRootModel(module, true, res, true, res.getClassPath());
        if (list != null) {
            res.getClassPath().addAll(list.getPathList());
        }
        res.getProgramParametersList().addAll(new String[]{"-p", GroovyScriptRunner.getPathInConf("console.txt")});
        res.setWorkingDirectory(ModuleRootManager.getInstance((Module)module).getContentRoots()[0].getPath());
        res.setUseDynamicClasspath(true);
        return res;
    }

    private static Consumer<Module> restarter(Project project, VirtualFile file) {
        return module -> GroovyConsole.createConsole(project, file, module);
    }
}

