/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrConditionalExprImpl
extends GrExpressionImpl
implements GrConditionalExpression {
    private static final Function<GrConditionalExpression, PsiType> TYPE_CALCULATOR = conditional -> {
        GrExpression thenBranch = conditional.getThenBranch();
        GrExpression elseBranch = conditional.getElseBranch();
        if (thenBranch == null) {
            if (elseBranch != null) {
                return elseBranch.getType();
            }
        } else {
            if (elseBranch == null) {
                return thenBranch.getType();
            }
            PsiType thenType = thenBranch.getType();
            PsiType elseType = elseBranch.getType();
            return TypesUtil.getLeastUpperBoundNullable(thenType, elseType, conditional.getManager());
        }
        return null;
    };

    public GrConditionalExprImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrConditionalExprImpl", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "Conditional expression";
    }

    @Override
    @NotNull
    public GrExpression getCondition() {
        GrExpression grExpression = (GrExpression)this.findNotNullChildByClass(GrExpression.class);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrConditionalExprImpl", "getCondition"));
        }
        return grExpression;
    }

    @Override
    @Nullable
    public GrExpression getThenBranch() {
        PsiElement question;
        for (PsiElement nextSibling = question = this.findChildByType(GroovyTokenTypes.mQUESTION); nextSibling != null && nextSibling.getNode().getElementType() != GroovyTokenTypes.mCOLON; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof GrExpression)) continue;
            return (GrExpression)nextSibling;
        }
        return null;
    }

    @Override
    @Nullable
    public GrExpression getElseBranch() {
        PsiElement colon;
        for (PsiElement nextSibling = colon = this.findChildByType(GroovyTokenTypes.mCOLON); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof GrExpression)) continue;
            return (GrExpression)nextSibling;
        }
        return null;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitConditionalExpression(this);
    }
}

