/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrBuiltinTypeClassExpressionImpl
extends GrExpressionImpl
implements GrBuiltinTypeClassExpression {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types.GrBuiltinTypeClassExpressionImpl");
    private static final Function<GrBuiltinTypeClassExpressionImpl, PsiType> TYPES_CALCULATOR = new MyTypesCalculator();

    public GrBuiltinTypeClassExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/types/GrBuiltinTypeClassExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitBuiltinTypeClassExpression(this);
    }

    public String toString() {
        return "builtin type class expression";
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    @NotNull
    public PsiPrimitiveType getPrimitiveType() {
        PsiPrimitiveType psiPrimitiveType = TypesUtil.getPrimitiveTypeByText(this.getText());
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/types/GrBuiltinTypeClassExpressionImpl", "getPrimitiveType"));
        }
        return psiPrimitiveType;
    }

    private static class MyTypesCalculator
    implements Function<GrBuiltinTypeClassExpressionImpl, PsiType> {
        private MyTypesCalculator() {
        }

        public PsiType fun(GrBuiltinTypeClassExpressionImpl expression) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
            PsiClass clazz = facade.findClass("java.lang.Class", expression.getResolveScope());
            if (clazz != null) {
                PsiElementFactory factory = facade.getElementFactory();
                PsiTypeParameter[] typeParameters = clazz.getTypeParameters();
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                if (typeParameters.length == 1) {
                    try {
                        PsiPrimitiveType type = expression.getPrimitiveType();
                        substitutor = substitutor.put(typeParameters[0], (PsiType)type);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                return factory.createType(clazz, substitutor);
            }
            return null;
        }
    }
}

