/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename.inplace;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.light.JavaIdentifier;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrMethodInplaceRenamer
extends MemberInplaceRenamer {
    public GrMethodInplaceRenamer(PsiNamedElement elementToRename, PsiElement substituted, Editor editor) {
        super(elementToRename, substituted, editor);
    }

    protected boolean isIdentifier(String newName, Language language) {
        return true;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/refactoring/rename/inplace/GrMethodInplaceRenamer", "getRangeToRename"));
        }
        TextRange range = GrMethodInplaceRenamer.getIdentifierNameRange(element);
        TextRange textRange = range != null ? range : super.getRangeToRename(element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/rename/inplace/GrMethodInplaceRenamer", "getRangeToRename"));
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/groovy/refactoring/rename/inplace/GrMethodInplaceRenamer", "getRangeToRename"));
        }
        TextRange range = GrMethodInplaceRenamer.getReferenceNameRange(reference.getElement());
        TextRange textRange = range != null ? range : super.getRangeToRename(reference);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/rename/inplace/GrMethodInplaceRenamer", "getRangeToRename"));
        }
        return textRange;
    }

    @Nullable
    private static TextRange getIdentifierNameRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/refactoring/rename/inplace/GrMethodInplaceRenamer", "getIdentifierNameRange"));
        }
        if (element instanceof JavaIdentifier) {
            return GrStringUtil.getStringContentRange(element.getNavigationElement());
        }
        return null;
    }

    @Nullable
    private static TextRange getReferenceNameRange(PsiElement element) {
        GrReferenceExpression referenceExpression;
        PsiElement nameElement;
        TextRange stringContentRange;
        if (element instanceof GrReferenceExpression && (stringContentRange = GrStringUtil.getStringContentRange(nameElement = (referenceExpression = (GrReferenceExpression)element).getReferenceNameElement())) != null) {
            return stringContentRange.shiftRight(nameElement.getStartOffsetInParent());
        }
        return null;
    }
}

