/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.ApplicationConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.runner.GroovyRunnerUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfigurationType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GroovyScriptRunConfigurationProducer
extends RuntimeConfigurationProducer
implements Cloneable {
    protected PsiElement mySourceElement;

    public GroovyScriptRunConfigurationProducer() {
        super((ConfigurationType)GroovyScriptRunConfigurationType.getInstance());
    }

    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        RunnerAndConfigurationSettings settings;
        PsiElement element = location.getPsiElement();
        PsiFile file = element.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        PsiClass aClass = GroovyRunnerPsiUtil.getRunningClass(location.getPsiElement());
        if ((aClass instanceof GroovyScriptClass || GroovyRunnerPsiUtil.isRunnable(aClass)) && (settings = this.createConfiguration(aClass)) != null) {
            this.mySourceElement = element;
            GroovyScriptRunConfiguration configuration = (GroovyScriptRunConfiguration)settings.getConfiguration();
            GroovyScriptUtil.getScriptType(groovyFile).tuneConfiguration(groovyFile, configuration, location);
            return settings;
        }
        if (file.getText().contains("@Grab")) {
            ApplicationConfigurationProducer producer = new ApplicationConfigurationProducer();
            ConfigurationFromContext settings2 = producer.createConfigurationFromContext(context);
            if (settings2 != null) {
                PsiElement src;
                this.mySourceElement = src = settings2.getSourceElement();
                return this.createConfiguration(src instanceof PsiMethod ? ((PsiMethod)src).getContainingClass() : (PsiClass)src);
            }
            return null;
        }
        return null;
    }

    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        if (existingConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingConfigurations", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfigurationProducer", "findExistingByElement"));
        }
        for (RunnerAndConfigurationSettings existingConfiguration : existingConfigurations) {
            VirtualFile vfile;
            PsiFile file;
            RunConfiguration configuration = existingConfiguration.getConfiguration();
            GroovyScriptRunConfiguration existing = (GroovyScriptRunConfiguration)configuration;
            String path = existing.getScriptPath();
            if (path == null || !((file = location.getPsiElement().getContainingFile()) instanceof GroovyFile) || (vfile = file.getVirtualFile()) == null || !FileUtil.toSystemIndependentName((String)path).equals(ScriptFileUtil.getScriptFilePath((VirtualFile)vfile)) || ((GroovyFile)file).isScript() && !GroovyScriptUtil.getScriptType((GroovyFile)file).isConfigurationByLocation(existing, location)) continue;
            return existingConfiguration;
        }
        return null;
    }

    public int compareTo(Object o) {
        return -1;
    }

    @Nullable
    private RunnerAndConfigurationSettings createConfiguration(@Nullable PsiClass aClass) {
        VirtualFile vFile;
        if (aClass == null) {
            return null;
        }
        Project project = aClass.getProject();
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).createConfiguration("", this.getConfigurationFactory());
        GroovyScriptRunConfiguration configuration = (GroovyScriptRunConfiguration)settings.getConfiguration();
        PsiFile file = aClass.getContainingFile().getOriginalFile();
        PsiDirectory dir = file.getContainingDirectory();
        if (dir != null) {
            configuration.setWorkingDirectory(dir.getVirtualFile().getPath());
        }
        if ((vFile = file.getVirtualFile()) == null) {
            return null;
        }
        String path = ScriptFileUtil.getScriptFilePath((VirtualFile)vFile);
        configuration.setScriptPath(path);
        RunConfigurationModule module = configuration.getConfigurationModule();
        String name = GroovyRunnerUtil.getConfigurationName(aClass, module);
        configuration.setName(StringUtil.isEmpty((String)name) ? vFile.getName() : name);
        configuration.setModule(JavaExecutionUtil.findModule((PsiClass)aClass));
        return settings;
    }
}

