/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltNamedElement;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.validation.DeclarationChecker;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltInspection;
import org.jetbrains.annotations.NotNull;

public class XsltDeclarationInspection
extends XsltInspection {
    private XsltElementFactory myXsltElementFactory;
    private NamesValidator myNamesValidator;

    @NotNull
    public String getDisplayName() {
        if ("Declaration Problems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection", "getDisplayName"));
        }
        return "Declaration Problems";
    }

    @NotNull
    public String getShortName() {
        if ("XsltDeclarations" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection", "getShortName"));
        }
        return "XsltDeclarations";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection", "buildVisitor"));
        }
        if (!(holder.getFile() instanceof XmlFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                XmlAttribute nameAttr = tag.getAttribute("name", null);
                if (nameAttr == null || PsiTreeUtil.hasErrorElements((PsiElement)nameAttr)) {
                    return;
                }
                if (XsltSupport.isVariableOrParam(tag)) {
                    XsltNamedElement instance = XsltDeclarationInspection.this.getXsltElementFactory().wrapElement(tag, XsltNamedElement.class);
                    this.checkDeclaration(instance, nameAttr.getValue(), holder);
                } else if (XsltSupport.isTemplate(tag)) {
                    XsltTemplate tmpl = XsltDeclarationInspection.this.getXsltElementFactory().wrapElement(tag, XsltTemplate.class);
                    this.checkDeclaration(tmpl, nameAttr.getValue(), holder);
                }
            }

            private void checkDeclaration(XsltNamedElement element, String name, ProblemsHolder holder2) {
                XmlTag tag = element.getTag();
                PsiElement token = element.getNameIdentifier();
                if (name == null || name.length() == 0) {
                    if (token != null) {
                        holder2.registerProblem(token, "Empty name not permitted", new LocalQuickFix[0]);
                    } else {
                        XmlAttributeValue e;
                        XmlAttribute attribute = element.getNameAttribute();
                        if (attribute != null && (e = attribute.getValueElement()) != null) {
                            holder2.registerProblem((PsiElement)e, "Empty name not permitted", new LocalQuickFix[0]);
                        }
                    }
                } else if (!this.isLegalName(name, holder2.getManager().getProject())) {
                    assert (token != null);
                    holder2.registerProblem(token, "Illegal name", new LocalQuickFix[0]);
                } else {
                    assert (token != null);
                    XmlFile file = (XmlFile)tag.getContainingFile();
                    XmlTag duplicatedSymbol = DeclarationChecker.getInstance(file).getDuplicatedSymbol(tag);
                    if (duplicatedSymbol != null) {
                        if (duplicatedSymbol.getContainingFile() == file) {
                            holder2.registerProblem(token, "Duplicate declaration", new LocalQuickFix[0]);
                        } else {
                            holder2.registerProblem(token, "Duplicates declaration from '" + duplicatedSymbol.getContainingFile().getName() + "'", new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private boolean isLegalName(String value, Project project) {
                return XsltDeclarationInspection.this.getNamesValidator().isIdentifier(value, project);
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    public XsltElementFactory getXsltElementFactory() {
        if (this.myXsltElementFactory == null) {
            this.myXsltElementFactory = XsltElementFactory.getInstance();
        }
        return this.myXsltElementFactory;
    }

    public NamesValidator getNamesValidator() {
        if (this.myNamesValidator == null) {
            this.myNamesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(XPathFileType.XPATH.getLanguage());
        }
        return this.myNamesValidator;
    }
}

