/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H$J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0014Jk\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00150\u001d26\u0010 \u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150!H\u0016J1\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010&\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u0002H%0\u001dH\u0016\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "dir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getDir", "()Ljava/nio/file/Path;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "addToIndex", "", "file", "path", "", "content", "", "size", "", "delete", "", "deleteFromIndex", "isFile", "deleteRepository", "has", "isPathIgnored", "processChildren", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "inputStream", "read", "R", "consumer", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "write", "settings-repository"})
public abstract class BaseRepositoryManager
implements RepositoryManager {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Path dir;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processChildren(@NotNull String path, @NotNull Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Path path2 = this.dir.resolve(path);
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(filter){
            final /* synthetic */ Function1 $filter;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)this.$filter.invoke((Object)((Object)it.getFileName()).toString());
            }
            {
                this.$filter = function1;
                super(1);
            }
        };
        try {
            void $receiver$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter)new PathKt.sam.Filter.i.855e4f15(filter$iv));
            boolean bl = false;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                for (Path file : it) {
                    boolean bl2;
                    BasicFileAttributes attributes;
                    try {
                        attributes = PathKt.basicAttributesIfExists((Path)file);
                    }
                    catch (IOException e) {
                        IcsManagerKt.getLOG().warn((Throwable)e);
                        continue;
                    }
                    if (attributes == null || attributes.isDirectory() || PathKt.isHidden((Path)file)) continue;
                    if (attributes.size() == 0L) {
                        Logger $receiver$iv2 = IcsManagerKt.getLOG();
                        try {
                            IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                            Path path3 = file;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"file");
                            this.delete(path3, path);
                        }
                        catch (ProcessCanceledException e$iv) {
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv2.error(e$iv);
                        }
                        continue;
                    }
                    Closeable closeable2 = PathKt.inputStream((Path)file);
                    boolean bl3 = false;
                    try {
                        InputStream it2 = (InputStream)closeable2;
                        bl2 = (Boolean)processor.invoke((Object)((Object)file.getFileName()).toString(), (Object)it2);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                        try {
                            Closeable closeable3 = closeable2;
                            if (closeable3 != null) {
                                closeable3.close();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw (Throwable)exception;
                    }
                    finally {
                        if (!bl3) {
                            Closeable closeable4 = closeable2;
                            if (closeable4 != null) {
                                closeable4.close();
                            }
                        }
                    }
                    if (bl2) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable5 = closeable;
                    if (closeable5 != null) {
                        closeable5.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable6 = closeable;
                    if (closeable6 != null) {
                        closeable6.close();
                    }
                }
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
    }

    @Override
    public void deleteRepository() {
        PathKt.delete((Path)this.dir);
    }

    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R read(@NotNull String path, @NotNull Function1<? super InputStream, ? extends R> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        Path fileToDelete = null;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Path file = this.dir.resolve(path);
            long l = PathKt.sizeOrNull((Path)file);
            if (l == -1L) {
                Object object = consumer.invoke(null);
                return (R)object;
            }
            if (l != 0L) {
                Object object;
                Closeable closeable = PathKt.inputStream((Path)file);
                Function1<? super InputStream, ? extends R> function1 = consumer;
                boolean bl = false;
                try {
                    object = function1.invoke((Object)closeable);
                }
                catch (Exception exception) {
                    bl = true;
                    try {
                        Closeable closeable2 = closeable;
                        if (closeable2 != null) {
                            closeable2.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                finally {
                    if (!bl) {
                        Closeable closeable3 = closeable;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                }
                Object object2 = object;
                return (R)object2;
            }
            fileToDelete = file;
            file = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        Logger $receiver$iv = IcsManagerKt.getLOG();
        try {
            Path path2 = fileToDelete;
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            if (PathKt.sizeOrNull((Path)path2) == 0L) {
                IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                Path path3 = fileToDelete;
                if (path3 == null) {
                    Intrinsics.throwNpe();
                }
                this.delete(path3, path);
            }
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            $receiver$iv.error(e$iv);
        }
        return (R)consumer.invoke(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(@NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Object $receiver$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Write " + path;
            logger.debug(string, (Throwable)e$iv);
        }
        try {
            int n;
            $receiver$iv = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)$receiver$iv).readLock();
            int n2 = ((ReentrantReadWriteLock)$receiver$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$receiver$iv).getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2 - 1;
            if (n3 <= n4) {
                do {
                    n = ++n3;
                    readLock.unlock();
                } while (n3 != n4);
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)$receiver$iv).writeLock();
            writeLock.lock();
            try {
                Path file = this.dir.resolve(path);
                PathKt.write((Path)file, (byte[])content, (int)0, (int)size);
                if (this.isPathIgnored(path)) {
                    Logger $receiver$iv2 = IcsManagerKt.getLOG();
                    Exception e$iv2 = null;
                    if ($receiver$iv2.isDebugEnabled()) {
                        Logger logger = $receiver$iv2;
                        String string = path + " is ignored and will be not added to index";
                        logger.debug(string, (Throwable)e$iv2);
                    }
                } else {
                    Path path2 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                    this.addToIndex(path2, path, content, size);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n2 - 1;
                if (n <= n5) {
                    do {
                        int n6 = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
            return false;
        }
        return true;
    }

    protected abstract void addToIndex(@NotNull Path var1, @NotNull String var2, @NotNull byte[] var3, int var4);

    @Override
    public boolean delete(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Logger $receiver$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Remove " + path;
            logger.debug(string, (Throwable)e$iv);
        }
        Path path2 = this.dir.resolve(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dir.resolve(path)");
        return this.delete(path2, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean delete(Path file, String path) {
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)file);
        if (basicFileAttributes == null) {
            return false;
        }
        BasicFileAttributes fileAttributes = basicFileAttributes;
        boolean isFile = fileAttributes.isRegularFile();
        if (!PathKt.deleteWithParentsIfEmpty((Path)file, (Path)this.dir, (boolean)isFile)) {
            return false;
        }
        if (!this.isPathIgnored(path)) {
            int n;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n2 = 0;
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n4 = n3 - 1;
            if (n2 <= n4) {
                do {
                    n = ++n2;
                    readLock.unlock();
                } while (n2 != n4);
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                this.deleteFromIndex(path, isFile);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n3 - 1;
                if (n <= n5) {
                    do {
                        int n6 = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
            }
        }
        return true;
    }

    protected abstract void deleteFromIndex(@NotNull String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(@NotNull String path) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            bl = PathKt.exists((Path)this.dir.resolve(path));
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    @NotNull
    protected final Path getDir() {
        return this.dir;
    }

    public BaseRepositoryManager(@NotNull Path dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.dir = dir;
        this.lock = new ReentrantReadWriteLock();
    }
}

