/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.transport.RefSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ImmutableUpdateResult;
import org.jetbrains.settingsRepository.MutableUpdateResult;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.DirCacheEditorKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryClient;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.MergeResultEx;
import org.jetbrains.settingsRepository.git.Pull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/settingsRepository/git/Reset;", "Lorg/jetbrains/settingsRepository/git/Pull;", "manager", "Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "reset", "Lorg/jetbrains/settingsRepository/UpdateResult;", "toTheirs", "", "localRepositoryInitializer", "Lkotlin/Function0;", "", "settings-repository"})
public final class Reset
extends Pull {
    @NotNull
    public final UpdateResult reset(boolean toTheirs, @Nullable Function0<Unit> localRepositoryInitializer) {
        ImmutableUpdateResult firstMergeResult;
        MergeResultEx mergeResult;
        MergeResultEx mergeResultEx;
        String message = toTheirs ? "Overwrite local to " + GitExKt.getUpstream(this.getManager().getRepository()) : "Overwrite remote " + GitExKt.getUpstream(this.getManager().getRepository()) + " to local";
        Logger $receiver$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = message;
            logger.debug(string, (Throwable)e$iv);
        }
        DirCacheCheckout resetResult = GitExKt.resetHard(this.getRepository());
        Collection collection = resetResult.getUpdated().keySet();
        List list = resetResult.getRemoved();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"resetResult.removed");
        MutableUpdateResult result = new MutableUpdateResult(collection, list);
        ProgressIndicator progressIndicator = this.getIndicator();
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        String commitMessage = this.getCommitMessageFormatter().message(message);
        MergeStrategy mergeStrategy = toTheirs ? MergeStrategy.THEIRS : MergeStrategy.OURS;
        Ref refToMerge = Pull.fetch$default(this, null, null, 3, null);
        if (refToMerge == null) {
            mergeResultEx = null;
        } else {
            MergeStrategy mergeStrategy2 = mergeStrategy;
            Intrinsics.checkExpressionValueIsNotNull((Object)mergeStrategy2, (String)"mergeStrategy");
            mergeResultEx = Pull.merge$default(this, refToMerge, mergeStrategy2, false, null, false, true, commitMessage, 28, null);
        }
        MergeResultEx mergeResultEx2 = mergeResult = mergeResultEx;
        ImmutableUpdateResult immutableUpdateResult = firstMergeResult = mergeResultEx2 != null ? mergeResultEx2.getResult() : null;
        if (!toTheirs) {
            MergeResultEx mergeResultEx3 = mergeResult;
            if (Intrinsics.areEqual((Object)(mergeResultEx3 != null ? mergeResultEx3.getStatus() : null), (Object)MergeResult.MergeStatus.FAST_FORWARD)) {
                Collection<String> collection2;
                ImmutableUpdateResult immutableUpdateResult2 = firstMergeResult;
                if (immutableUpdateResult2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!(collection2 = immutableUpdateResult2.getChanged()).isEmpty()) {
                    DirCacheEditorKt.deleteAllFiles$default(this.getRepository(), null, false, 3, null);
                    result.getDeleted().addAll(firstMergeResult.getChanged());
                    GitExKt.commit$default(this.getRepository(), commitMessage, null, null, null, 14, null);
                }
            }
        }
        if (localRepositoryInitializer == null) {
            if (firstMergeResult == null) {
                Ref latestUpstreamCommit;
                boolean bl;
                List fetchRefSpecs = this.getRemoteConfig().getFetchRefSpecs();
                boolean bl2 = bl = fetchRefSpecs.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Repository repository2 = this.getRepository();
                String string = ((RefSpec)fetchRefSpecs.get(0)).getDestination();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((latestUpstreamCommit = repository2.findRef(string)) == null) {
                    if (toTheirs) {
                        DirCacheEditorKt.deleteAllFiles$default(this.getRepository(), (Set)result.getDeleted(), false, 2, null);
                        result.getChanged().removeAll((Collection)result.getDeleted());
                        GitExKt.commit$default(this.getRepository(), commitMessage, null, null, null, 14, null);
                    } else {
                        IcsManagerKt.getLOG().debug("uninitialized remote (empty) - we don't need to merge");
                    }
                    return result;
                }
                if (Intrinsics.areEqual((Object)this.getRepository().getRepositoryState(), (Object)RepositoryState.MERGING)) {
                    GitExKt.resetHard(this.getRepository());
                }
                MergeStrategy mergeStrategy3 = mergeStrategy;
                Intrinsics.checkExpressionValueIsNotNull((Object)mergeStrategy3, (String)"mergeStrategy");
                MergeResultEx secondMergeResult = Pull.merge$default(this, latestUpstreamCommit, mergeStrategy3, true, null, false, true, commitMessage, 24, null);
                if (!secondMergeResult.getStatus().isSuccessful()) {
                    throw (Throwable)new IllegalStateException(secondMergeResult.toString());
                }
                result.add(secondMergeResult.getResult());
            } else {
                result.add(firstMergeResult);
            }
        } else {
            boolean bl;
            boolean bl3 = bl = !toTheirs;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            result.add(firstMergeResult);
            localRepositoryInitializer.invoke();
            GitRepositoryClient gitRepositoryClient = this.getManager();
            if (gitRepositoryClient == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.git.GitRepositoryManager");
            }
            RepositoryManager.DefaultImpls.commit$default((GitRepositoryManager)gitRepositoryClient, this.getIndicator(), null, false, 6, null);
        }
        return result;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ UpdateResult reset$default(Reset reset, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        return reset.reset(bl, (Function0<Unit>)function0);
    }

    public Reset(@NotNull GitRepositoryManager manager, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        super(manager, indicator, null, 4, null);
    }
}

