/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputMessageUtil {
    private static final String SOURCE_FILES_PREFIX = "Sources:";
    private static final String OUTPUT_FILES_PREFIX = "Output:";

    @NotNull
    public static String renderException(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil", "renderException"));
        }
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil", "renderException"));
        }
        return string;
    }

    @NotNull
    public static String formatOutputMessage(Collection<File> sourceFiles, File outputFile) {
        String string = "Output:\n" + outputFile.getPath() + "\n" + SOURCE_FILES_PREFIX + "\n" + StringUtil.join(sourceFiles, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil", "formatOutputMessage"));
        }
        return string;
    }

    @Nullable
    public static Output parseOutputMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil", "parseOutputMessage"));
        }
        String[] strings = message.split("\n");
        if (strings.length <= 2) {
            return null;
        }
        if (!OUTPUT_FILES_PREFIX.equals(strings[0])) {
            return null;
        }
        if (SOURCE_FILES_PREFIX.equals(strings[1])) {
            return new Output(OutputMessageUtil.parseSourceFiles(strings, 2), null);
        }
        File outputFile = new File(strings[1]);
        if (!SOURCE_FILES_PREFIX.equals(strings[2])) {
            return null;
        }
        return new Output(OutputMessageUtil.parseSourceFiles(strings, 3), outputFile);
    }

    private static Collection<File> parseSourceFiles(String[] strings, int start) {
        ArrayList sourceFiles = ContainerUtil.newArrayList();
        for (int i = start; i < strings.length; ++i) {
            sourceFiles.add(new File(strings[i]));
        }
        return sourceFiles;
    }

    public static class Output
    implements Serializable {
        @NotNull
        public final Collection<File> sourceFiles;
        @Nullable
        public final File outputFile;
        static final long serialVersionUID = 0L;

        public Output(@NotNull Collection<File> sourceFiles, @Nullable File outputFile) {
            if (sourceFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/cli/common/messages/OutputMessageUtil$Output", "<init>"));
            }
            this.sourceFiles = sourceFiles;
            this.outputFile = outputFile;
        }
    }
}

