/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl$WhenMappings;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "specificFeatures", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;Ljava/util/Map;)V", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "enabledFlags", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "Lkotlin/collections/HashSet;", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "getFeatureSupport", "feature", "isFlagEnabled", "", "flag", "switchFlag", "", "enable", "toString", "", "Companion", "util"})
public final class LanguageVersionSettingsImpl
implements LanguageVersionSettings {
    private final HashSet<AnalysisFlag> enabledFlags;
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    private final Map<LanguageFeature, LanguageFeature.State> specificFeatures;
    @JvmField
    @NotNull
    public static final LanguageVersionSettingsImpl DEFAULT;
    public static final Companion Companion;

    @Override
    public boolean isFlagEnabled(@NotNull AnalysisFlag flag) {
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        return this.enabledFlags.contains(flag);
    }

    public final void switchFlag(@NotNull AnalysisFlag flag, boolean enable) {
        Intrinsics.checkParameterIsNotNull((Object)flag, (String)"flag");
        if (enable) {
            this.enabledFlags.add(flag);
        } else {
            this.enabledFlags.remove(flag);
        }
    }

    @Override
    @NotNull
    public LanguageFeature.State getFeatureSupport(@NotNull LanguageFeature feature) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
        LanguageFeature.State state = this.specificFeatures.get((Object)feature);
        if (state != null) {
            LanguageFeature.State state2;
            LanguageFeature.State it = state2 = state;
            return it;
        }
        LanguageVersion since = feature.getSinceVersion();
        if (since != null && this.getLanguageVersion().compareTo((Enum)since) >= 0 && this.getApiVersion().compareTo(feature.getSinceApiVersion()) >= 0) {
            return feature.getDefaultState();
        }
        return LanguageFeature.State.DISABLED;
    }

    @NotNull
    public String toString() {
        Map<LanguageFeature, LanguageFeature.State> $receiver$iv;
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append("Language = " + this.getLanguageVersion() + ", API = " + this.getApiVersion());
        Map<LanguageFeature, LanguageFeature.State> map = $receiver$iv = this.specificFeatures;
        Iterator<Map.Entry<LanguageFeature, LanguageFeature.State>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            char c;
            Map.Entry<LanguageFeature, LanguageFeature.State> element$iv;
            Map.Entry<LanguageFeature, LanguageFeature.State> $feature_state;
            Map.Entry<LanguageFeature, LanguageFeature.State> entry = $feature_state = (element$iv = iterator2.next());
            LanguageFeature feature = entry.getKey();
            entry = $feature_state;
            LanguageFeature.State state = entry.getValue();
            switch (LanguageVersionSettingsImpl$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    c = '+';
                    break;
                }
                case 2: {
                    c = '~';
                    break;
                }
                case 3: 
                case 4: {
                    c = '-';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            char c2 = c;
            $receiver.append(" " + c2 + (Object)((Object)feature));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<LanguageFeature, ? extends LanguageFeature.State> specificFeatures) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkParameterIsNotNull((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkParameterIsNotNull(specificFeatures, (String)"specificFeatures");
        this.languageVersion = languageVersion;
        this.apiVersion = apiVersion;
        this.specificFeatures = specificFeatures;
        LanguageVersionSettingsImpl languageVersionSettingsImpl = this;
        HashSet hashSet = new HashSet();
        languageVersionSettingsImpl.enabledFlags = hashSet;
    }

    @JvmOverloads
    public /* synthetic */ LanguageVersionSettingsImpl(LanguageVersion languageVersion, ApiVersion apiVersion, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(languageVersion, apiVersion, map);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion) {
        this(languageVersion, apiVersion, null, 4, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST_STABLE, null, 4, null);
    }

    @Override
    public boolean supportsFeature(@NotNull LanguageFeature feature) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
        return LanguageVersionSettings.DefaultImpls.supportsFeature(this, feature);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

