/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalysisResultEntry;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzerTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class DuplicatedBitmapAnalyzerTask
extends MemoryAnalyzerTask {
    @Override
    protected List<AnalysisResultEntry<?>> analyze(MemoryAnalyzerTask.Configuration configuration, Snapshot snapshot) {
        ClassObj bitmapClass = snapshot.findClass("android.graphics.Bitmap");
        if (bitmapClass == null) {
            return Collections.emptyList();
        }
        HashMap byteArrayToBitmapMap = new HashMap();
        HashSet byteArrays = new HashSet();
        ArrayList reachableInstances = new ArrayList();
        configuration.mHeaps.stream().forEach(heap -> bitmapClass.getHeapInstances(heap.getId()).stream().filter(instance -> instance.getDistanceToGcRoot() != Integer.MAX_VALUE).forEach(reachableInstances::add));
        reachableInstances.forEach(instance -> byteArrayToBitmapMap.put((ArrayInstance)((ClassInstance)instance).getValues().stream().filter(fieldValue -> fieldValue.getField().getName().equals("mBuffer")).findFirst().get().getValue(), instance));
        byteArrays.addAll(byteArrayToBitmapMap.keySet());
        if (byteArrays.size() <= 1) {
            return Collections.emptyList();
        }
        ArrayList results = new ArrayList();
        ArrayList<HashSet<Object>> commonPrefixSets = new ArrayList<HashSet<Object>>();
        ArrayList<Set> reducedPrefixSets = new ArrayList<Set>();
        commonPrefixSets.add(byteArrays);
        HashMap<ArrayInstance, Object[]> cachedValues = new HashMap<ArrayInstance, Object[]>();
        cachedValues.clear();
        for (ArrayInstance instance2 : byteArrays) {
            cachedValues.put(instance2, instance2.getValues());
        }
        int columnIndex = 0;
        while (!commonPrefixSets.isEmpty()) {
            for (Set set : commonPrefixSets) {
                HashMap entryClassifier = new HashMap(set.size());
                for (ArrayInstance arrayInstance : set) {
                    Object element = ((Object[])cachedValues.get(arrayInstance))[columnIndex];
                    if (entryClassifier.containsKey(element)) {
                        ((Set)entryClassifier.get(element)).add(arrayInstance);
                        continue;
                    }
                    HashSet<ArrayInstance> instanceSet = new HashSet<ArrayInstance>();
                    instanceSet.add(arrayInstance);
                    entryClassifier.put(element, instanceSet);
                }
                for (Set branch : entryClassifier.values()) {
                    if (branch.size() <= 1) continue;
                    HashSet<ArrayInstance> terminatedArrays = new HashSet<ArrayInstance>();
                    for (ArrayInstance instance3 : branch) {
                        if (instance3.getLength() != columnIndex + 1) continue;
                        terminatedArrays.add(instance3);
                    }
                    branch.removeAll(terminatedArrays);
                    if (terminatedArrays.size() > 1) {
                        int byteArraySize = -1;
                        ArrayList duplicateBitmaps = new ArrayList();
                        for (ArrayInstance terminatedArray : terminatedArrays) {
                            duplicateBitmaps.add(byteArrayToBitmapMap.get(terminatedArray));
                            byteArraySize = terminatedArray.getLength();
                        }
                        results.add(new DuplicatedBitmapEntry(new ArrayList(duplicateBitmaps), byteArraySize));
                    }
                    if (branch.size() <= 1) continue;
                    reducedPrefixSets.add(branch);
                }
            }
            commonPrefixSets.clear();
            commonPrefixSets.addAll(reducedPrefixSets);
            reducedPrefixSets.clear();
            ++columnIndex;
        }
        return results;
    }

    @Override
    public String getTaskName() {
        return "Duplicated Bitmaps";
    }

    @Override
    public String getTaskDescription() {
        return "Detects duplicated bitmaps in the application.";
    }

    public static final class DuplicatedBitmapEntry
    extends MemoryAnalysisResultEntry {
        private final int mByteArraySize;

        private DuplicatedBitmapEntry(List<Instance> duplicates, int byteArraySize) {
            super("Duplicated Bitmap", duplicates);
            this.mByteArraySize = byteArraySize;
        }

        @Override
        public String getWarningMessage() {
            return String.format("%d instances: \"%s\"", this.mOffender.getOffenders().size(), this.mOffender.getOffendingDescription());
        }

        @Override
        public String getCategory() {
            return "Duplicated Bitmaps";
        }

        public int getByteArraySize() {
            return this.mByteArraySize;
        }
    }
}

