/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.XmlMessageRenderer;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

public interface MessageRenderer {
    public static final MessageRenderer XML = new XmlMessageRenderer();
    public static final MessageRenderer WITHOUT_PATHS = new PlainTextMessageRenderer(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            if (location2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "getPath"));
        }
    };
    public static final MessageRenderer PLAIN_FULL_PATHS = new PlainTextMessageRenderer(){

        @Override
        @NotNull
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            if (location2 == null) {
                2.$$$reportNull$$$0(0);
            }
            String string = location2.getPath();
            if (string == null) {
                2.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final MessageRenderer PLAIN_RELATIVE_PATHS = new PlainTextMessageRenderer(){
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @NotNull
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            if (location2 == null) {
                3.$$$reportNull$$$0(0);
            }
            String string = FileUtilsKt.descendantRelativeTo(new File(location2.getPath()), this.cwd).getPath();
            if (string == null) {
                3.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public String renderPreamble();

    public String render(@NotNull CompilerMessageSeverity var1, @NotNull String var2, @Nullable CompilerMessageLocation var3);

    public String renderConclusion();
}

