/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.google.common.collect.Lists;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.AnonymousObjectTransformationInfo;
import org.jetbrains.kotlin.codegen.inline.AsmTypeRemapper;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.InlineAdapter;
import org.jetbrains.kotlin.codegen.inline.InlineCallSiteInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.InlineException;
import org.jetbrains.kotlin.codegen.inline.InlineLambdaSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineOnlySmapSkipper;
import org.jetbrains.kotlin.codegen.inline.InlineResult;
import org.jetbrains.kotlin.codegen.inline.InlinedLambdaRemapper;
import org.jetbrains.kotlin.codegen.inline.InliningContext;
import org.jetbrains.kotlin.codegen.inline.InternalFinallyBlockInliner;
import org.jetbrains.kotlin.codegen.inline.InvokeCall;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.MethodBodyVisitor;
import org.jetbrains.kotlin.codegen.inline.MethodInlinerUtilKt;
import org.jetbrains.kotlin.codegen.inline.NestedSourceMapper;
import org.jetbrains.kotlin.codegen.inline.ObjectTransformer;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.RegeneratedClassContext;
import org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInlinerKt;
import org.jetbrains.kotlin.codegen.inline.RemapVisitor;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.inline.TransformationInfo;
import org.jetbrains.kotlin.codegen.inline.TypeRemapper;
import org.jetbrains.kotlin.codegen.inline.WhenMappingTransformationInfo;
import org.jetbrains.kotlin.codegen.optimization.FixStackWithLabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.commons.RemappingMethodAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceValue;
import org.jetbrains.org.objectweb.asm.util.Printer;

public class MethodInliner {
    private final MethodNode node;
    private final Parameters parameters;
    private final InliningContext inliningContext;
    private final FieldRemapper nodeRemapper;
    private final boolean isSameModule;
    private final String errorPrefix;
    private final SourceMapper sourceMapper;
    private final InlineCallSiteInfo inlineCallSiteInfo;
    private final KotlinTypeMapper typeMapper;
    private final List<InvokeCall> invokeCalls;
    private final List<TransformationInfo> transformations;
    private final Map<String, String> currentTypeMapping;
    private final InlineResult result;
    private int lambdasFinallyBlocks;
    private final InlineOnlySmapSkipper inlineOnlySmapSkipper;

    public MethodInliner(@NotNull MethodNode node, @NotNull Parameters parameters2, @NotNull InliningContext inliningContext, @NotNull FieldRemapper nodeRemapper, boolean isSameModule, @NotNull String errorPrefix, @NotNull SourceMapper sourceMapper, @NotNull InlineCallSiteInfo inlineCallSiteInfo, @Nullable InlineOnlySmapSkipper smapSkipper) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(0);
        }
        if (parameters2 == null) {
            MethodInliner.$$$reportNull$$$0(1);
        }
        if (inliningContext == null) {
            MethodInliner.$$$reportNull$$$0(2);
        }
        if (nodeRemapper == null) {
            MethodInliner.$$$reportNull$$$0(3);
        }
        if (errorPrefix == null) {
            MethodInliner.$$$reportNull$$$0(4);
        }
        if (sourceMapper == null) {
            MethodInliner.$$$reportNull$$$0(5);
        }
        if (inlineCallSiteInfo == null) {
            MethodInliner.$$$reportNull$$$0(6);
        }
        this.invokeCalls = new ArrayList<InvokeCall>();
        this.transformations = new ArrayList<TransformationInfo>();
        this.currentTypeMapping = new HashMap<String, String>();
        this.node = node;
        this.parameters = parameters2;
        this.inliningContext = inliningContext;
        this.nodeRemapper = nodeRemapper;
        this.isSameModule = isSameModule;
        this.errorPrefix = errorPrefix;
        this.sourceMapper = sourceMapper;
        this.inlineCallSiteInfo = inlineCallSiteInfo;
        this.typeMapper = inliningContext.state.getTypeMapper();
        this.result = InlineResult.create();
        this.inlineOnlySmapSkipper = smapSkipper;
    }

    @NotNull
    public InlineResult doInline(@NotNull MethodVisitor adapter, @NotNull LocalVarRemapper remapper, boolean remapReturn, @NotNull LabelOwner labelOwner) {
        if (adapter == null) {
            MethodInliner.$$$reportNull$$$0(7);
        }
        if (remapper == null) {
            MethodInliner.$$$reportNull$$$0(8);
        }
        if (labelOwner == null) {
            MethodInliner.$$$reportNull$$$0(9);
        }
        InlineResult inlineResult = this.doInline(adapter, remapper, remapReturn, labelOwner, 0);
        if (inlineResult == null) {
            MethodInliner.$$$reportNull$$$0(10);
        }
        return inlineResult;
    }

    @NotNull
    private InlineResult doInline(@NotNull MethodVisitor adapter, @NotNull LocalVarRemapper remapper, boolean remapReturn, @NotNull LabelOwner labelOwner, int finallyDeepShift) {
        if (adapter == null) {
            MethodInliner.$$$reportNull$$$0(11);
        }
        if (remapper == null) {
            MethodInliner.$$$reportNull$$$0(12);
        }
        if (labelOwner == null) {
            MethodInliner.$$$reportNull$$$0(13);
        }
        MethodNode transformedNode = this.markPlacesForInlineAndRemoveInlinable(this.node, labelOwner, finallyDeepShift);
        Label end = new Label();
        transformedNode = this.doInline(transformedNode);
        MethodInliner.removeClosureAssertions(transformedNode);
        transformedNode.instructions.resetLabels();
        MethodNode resultNode = new MethodNode(327680, transformedNode.access, transformedNode.name, transformedNode.desc, transformedNode.signature, ArrayUtil.toStringArray(transformedNode.exceptions));
        RemapVisitor visitor2 = new RemapVisitor(resultNode, remapper, this.nodeRemapper);
        try {
            transformedNode.accept(visitor2);
        }
        catch (Throwable e) {
            throw this.wrapException(e, transformedNode, "couldn't inline method call");
        }
        resultNode.visitLabel(end);
        if (this.inliningContext.isRoot()) {
            StackValue remapValue = remapper.remap((int)(this.parameters.getArgsSizeOnStack() + 1)).value;
            InternalFinallyBlockInliner.processInlineFunFinallyBlocks(resultNode, this.lambdasFinallyBlocks, ((StackValue.Local)remapValue).index);
        }
        MethodInliner.processReturns(resultNode, labelOwner, remapReturn, end);
        resultNode.accept(new MethodBodyVisitor(adapter));
        this.sourceMapper.endMapping();
        InlineResult inlineResult = this.result;
        if (inlineResult == null) {
            MethodInliner.$$$reportNull$$$0(14);
        }
        return inlineResult;
    }

    @NotNull
    private MethodNode doInline(@NotNull MethodNode node) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(15);
        }
        final LinkedList<InvokeCall> currentInvokes = new LinkedList<InvokeCall>(this.invokeCalls);
        final MethodNode resultNode = new MethodNode(node.access, node.name, node.desc, node.signature, null);
        final Iterator<TransformationInfo> iterator2 = this.transformations.iterator();
        final TypeRemapper remapper = TypeRemapper.createFrom(this.currentTypeMapping);
        final RemappingMethodAdapter remappingMethodAdapter = new RemappingMethodAdapter(resultNode.access, resultNode.desc, resultNode, new AsmTypeRemapper(remapper, this.inliningContext.getRoot().typeParameterMappings == null, this.result));
        final int markerShift = InlineCodegenUtil.calcMarkerShift(this.parameters, node);
        InlineAdapter lambdaInliner = new InlineAdapter(remappingMethodAdapter, this.parameters.getArgsSizeOnStack(), this.sourceMapper){
            private TransformationInfo transformationInfo;

            private void handleAnonymousObjectRegeneration() {
                this.transformationInfo = (TransformationInfo)iterator2.next();
                String oldClassName = this.transformationInfo.getOldClassName();
                if (this.transformationInfo.shouldRegenerate(MethodInliner.this.isSameModule)) {
                    String newClassName = this.transformationInfo.getNewClassName();
                    remapper.addMapping(oldClassName, newClassName);
                    InliningContext childInliningContext = MethodInliner.this.inliningContext.subInlineWithClassRegeneration(((MethodInliner)MethodInliner.this).inliningContext.nameGenerator, MethodInliner.this.currentTypeMapping, MethodInliner.this.inlineCallSiteInfo);
                    ObjectTransformer<?> transformer = this.transformationInfo.createTransformer(childInliningContext, MethodInliner.this.isSameModule);
                    InlineResult transformResult = transformer.doTransform(MethodInliner.this.nodeRemapper);
                    MethodInliner.this.result.merge(transformResult);
                    MethodInliner.this.result.addChangedType(oldClassName, newClassName);
                    if (((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda && this.transformationInfo.canRemoveAfterTransformation()) {
                        MethodInliner.this.result.addClassToRemove(oldClassName);
                    }
                    if (transformResult.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
                        ReifiedTypeInliner.putNeedClassReificationMarker(this.mv);
                        MethodInliner.this.result.getReifiedTypeParametersUsages().mergeAll(transformResult.getReifiedTypeParametersUsages());
                    }
                } else if (!this.transformationInfo.getWasAlreadyRegenerated()) {
                    MethodInliner.this.result.addNotChangedClass(oldClassName);
                }
            }

            @Override
            public void anew(@NotNull Type type2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (InlineCodegenUtil.isAnonymousClass(type2.getInternalName())) {
                    this.handleAnonymousObjectRegeneration();
                }
                super.anew(type2);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (InlineCodegenUtil.isInvokeOnLambda(owner, name)) {
                    assert (!currentInvokes.isEmpty());
                    InvokeCall invokeCall = (InvokeCall)currentInvokes.remove();
                    LambdaInfo info = invokeCall.lambdaInfo;
                    if (info == null) {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        return;
                    }
                    int valueParamShift = Math.max(this.getNextLocalIndex(), markerShift);
                    MethodInliner.putStackValuesIntoLocals(info.getInvokeParamsWithoutCaptured(), valueParamShift, this, desc);
                    if (invokeCall.lambdaInfo.getFunctionDescriptor().getValueParameters().isEmpty()) {
                        this.visitInsn(0);
                    }
                    InlineCodegenUtil.addInlineMarker(this, true);
                    Parameters lambdaParameters = info.addAllParameters(MethodInliner.this.nodeRemapper);
                    InlinedLambdaRemapper newCapturedRemapper = new InlinedLambdaRemapper(info.getLambdaClassType().getInternalName(), MethodInliner.this.nodeRemapper, lambdaParameters);
                    this.setLambdaInlining(true);
                    SMAP lambdaSMAP = info.getNode().getClassSMAP();
                    NestedSourceMapper mapper = ((MethodInliner)MethodInliner.this).inliningContext.classRegeneration && !((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda ? new NestedSourceMapper(MethodInliner.this.sourceMapper, lambdaSMAP.getIntervals(), lambdaSMAP.getSourceInfo()) : new InlineLambdaSourceMapper(MethodInliner.this.sourceMapper.getParent(), info.getNode());
                    MethodInliner inliner = new MethodInliner(info.getNode().getNode(), lambdaParameters, MethodInliner.this.inliningContext.subInlineLambda(info), newCapturedRemapper, true, "Lambda inlining " + info.getLambdaClassType().getInternalName(), mapper, MethodInliner.this.inlineCallSiteInfo, null);
                    LocalVarRemapper remapper2 = new LocalVarRemapper(lambdaParameters, valueParamShift);
                    InlineResult lambdaResult = inliner.doInline(this.mv, remapper2, true, info, invokeCall.finallyDepthShift);
                    MethodInliner.this.result.mergeWithNotChangeInfo(lambdaResult);
                    MethodInliner.this.result.getReifiedTypeParametersUsages().mergeAll(lambdaResult.getReifiedTypeParametersUsages());
                    Method bridge = MethodInliner.this.typeMapper.mapAsmMethod(ClosureCodegen.getErasedInvokeFunction(info.getFunctionDescriptor()));
                    Method delegate2 = MethodInliner.this.typeMapper.mapAsmMethod(info.getFunctionDescriptor());
                    StackValue.onStack(delegate2.getReturnType()).put(bridge.getReturnType(), this);
                    this.setLambdaInlining(false);
                    InlineCodegenUtil.addInlineMarker(this, false);
                    mapper.endMapping();
                    if (MethodInliner.this.inlineOnlySmapSkipper != null) {
                        MethodInliner.this.inlineOnlySmapSkipper.markCallSiteLineNumber(remappingMethodAdapter);
                    }
                } else if (InlineCodegenUtil.isAnonymousConstructorCall(owner, name)) {
                    boolean isContinuation;
                    assert (this.transformationInfo instanceof AnonymousObjectTransformationInfo) : "<init> call doesn't correspond to object transformation info: " + owner + "." + name + ", info " + this.transformationInfo;
                    InliningContext parent2 = MethodInliner.this.inliningContext.getParent();
                    boolean shouldRegenerate = this.transformationInfo.shouldRegenerate(MethodInliner.this.isSameModule);
                    boolean bl = isContinuation = parent2 != null && parent2.isContinuation();
                    if (shouldRegenerate || isContinuation) {
                        assert (shouldRegenerate || MethodInliner.this.inlineCallSiteInfo.getOwnerClassName().equals(this.transformationInfo.getOldClassName())) : "Only coroutines can call their own constructors";
                        AnonymousObjectTransformationInfo info = (AnonymousObjectTransformationInfo)this.transformationInfo;
                        AnonymousObjectTransformationInfo oldInfo = MethodInliner.this.inliningContext.findAnonymousObjectTransformationInfo(owner);
                        if (oldInfo != null && isContinuation) {
                            info = oldInfo;
                        }
                        for (CapturedParamDesc capturedParamDesc : info.getAllRecapturedParameters()) {
                            this.visitFieldInsn(178, capturedParamDesc.getContainingLambdaName(), "$$$" + capturedParamDesc.getFieldName(), capturedParamDesc.getType().getDescriptor());
                        }
                        super.visitMethodInsn(opcode, info.getNewClassName(), name, info.getNewConstructorDescriptor(), itf);
                        if (MethodInliner.this.inliningContext.getParent() instanceof RegeneratedClassContext) {
                            ((MethodInliner)MethodInliner.this).inliningContext.getParent().typeRemapper.addAdditionalMappings(this.transformationInfo.getOldClassName(), this.transformationInfo.getNewClassName());
                        }
                        this.transformationInfo = null;
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                } else if (((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda || !ReifiedTypeInliner.isNeedClassReificationMarker(new MethodInsnNode(opcode, owner, name, desc, false))) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }

            @Override
            public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc) {
                if (owner == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (desc == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (opcode == 178 && (InlineCodegenUtil.isAnonymousSingletonLoad(owner, name) || InlineCodegenUtil.isWhenMappingAccess(owner, name))) {
                    this.handleAnonymousObjectRegeneration();
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            @Override
            public void visitMaxs(int stack, int locals) {
                MethodInliner.this.lambdasFinallyBlocks = resultNode.tryCatchBlocks.size();
                super.visitMaxs(stack, locals);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "owner";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "desc";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/MethodInliner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "anew";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFieldInsn";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        node.accept(lambdaInliner);
        MethodNode methodNode = resultNode;
        if (methodNode == null) {
            MethodInliner.$$$reportNull$$$0(16);
        }
        return methodNode;
    }

    @NotNull
    public static CapturedParamInfo findCapturedField(@NotNull FieldInsnNode node, @NotNull FieldRemapper fieldRemapper) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(17);
        }
        if (fieldRemapper == null) {
            MethodInliner.$$$reportNull$$$0(18);
        }
        assert (node.name.startsWith("$$$")) : "Captured field template should start with $$$ prefix";
        FieldInsnNode fin = new FieldInsnNode(node.getOpcode(), node.owner, node.name.substring(3), node.desc);
        CapturedParamInfo field = fieldRemapper.findField(fin);
        if (field == null) {
            throw new IllegalStateException("Couldn't find captured field " + node.owner + "." + node.name + " in " + fieldRemapper.getLambdaInternalName());
        }
        CapturedParamInfo capturedParamInfo = field;
        if (capturedParamInfo == null) {
            MethodInliner.$$$reportNull$$$0(19);
        }
        return capturedParamInfo;
    }

    @NotNull
    private MethodNode prepareNode(@NotNull MethodNode node, int finallyDeepShift) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(20);
        }
        final int capturedParamsSize = this.parameters.getCapturedParametersSizeOnStack();
        final int realParametersSize = this.parameters.getRealParametersSizeOnStack();
        Type[] types = Type.getArgumentTypes(node.desc);
        Type returnType = Type.getReturnType(node.desc);
        List<Type> capturedTypes = this.parameters.getCapturedTypes();
        Type[] allTypes = ArrayUtil.mergeArrays(types, capturedTypes.toArray(new Type[capturedTypes.size()]));
        node.instructions.resetLabels();
        MethodNode transformedNode = new MethodNode(327680, node.access, node.name, Type.getMethodDescriptor(returnType, allTypes), node.signature, null){
            private final boolean GENERATE_DEBUG_INFO;
            private final boolean isInliningLambda;
            {
                super(x0, x1, x2, x3, x4, x5);
                this.GENERATE_DEBUG_INFO = MethodInliner.this.inlineOnlySmapSkipper == null;
                this.isInliningLambda = MethodInliner.this.nodeRemapper.isInsideInliningLambda();
            }

            private int getNewIndex(int var) {
                return var + (var < realParametersSize ? 0 : capturedParamsSize);
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, this.getNewIndex(var));
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                super.visitIincInsn(this.getNewIndex(var), increment);
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack, maxLocals + capturedParamsSize);
            }

            @Override
            public void visitLineNumber(int line, @NotNull Label start) {
                if (start == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.isInliningLambda || this.GENERATE_DEBUG_INFO) {
                    super.visitLineNumber(line, start);
                }
            }

            @Override
            public void visitLocalVariable(@NotNull String name, @NotNull String desc, String signature, @NotNull Label start, @NotNull Label end, int index2) {
                if (name == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (desc == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (start == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (end == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (this.isInliningLambda || this.GENERATE_DEBUG_INFO) {
                    String varSuffix = MethodInliner.this.inliningContext.isRoot() && !InlineCodegenUtil.isFakeLocalVariableForInline(name) ? "$iv" : "";
                    String varName = !varSuffix.isEmpty() && name.equals("this") ? name + "_" : name;
                    super.visitLocalVariable(varName + varSuffix, desc, signature, start, end, this.getNewIndex(index2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "start";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "desc";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "end";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/MethodInliner$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLineNumber";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLocalVariable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        node.accept(transformedNode);
        this.transformCaptured(transformedNode);
        MethodInliner.transformFinallyDeepIndex(transformedNode, finallyDeepShift);
        MethodNode methodNode = transformedNode;
        if (methodNode == null) {
            MethodInliner.$$$reportNull$$$0(21);
        }
        return methodNode;
    }

    @NotNull
    private MethodNode markPlacesForInlineAndRemoveInlinable(@NotNull MethodNode node, @NotNull LabelOwner labelOwner, int finallyDeepShift) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(22);
        }
        if (labelOwner == null) {
            MethodInliner.$$$reportNull$$$0(23);
        }
        node = this.prepareNode(node, finallyDeepShift);
        this.normalizeLocalReturns(node, labelOwner);
        Frame<SourceValue>[] sources = MethodInliner.analyzeMethodNodeWithoutMandatoryTransformations(node);
        SmartSet<AbstractInsnNode> toDelete = SmartSet.create();
        InsnList instructions = node.instructions;
        boolean awaitClassReification = false;
        int currentFinallyDeep = 0;
        for (AbstractInsnNode cur = instructions.getFirst(); cur != null; cur = cur.getNext()) {
            Frame<SourceValue> frame = sources[instructions.indexOf(cur)];
            if (frame != null) {
                SourceValue top;
                LambdaInfo lambdaInfo;
                if (ReifiedTypeInliner.isNeedClassReificationMarker(cur)) {
                    awaitClassReification = true;
                } else if (cur.getType() == 5) {
                    if (InlineCodegenUtil.isFinallyStart(cur)) {
                        currentFinallyDeep = InlineCodegenUtil.getConstant(cur.getPrevious());
                    }
                    MethodInsnNode methodInsnNode = (MethodInsnNode)cur;
                    String owner = methodInsnNode.owner;
                    String desc = methodInsnNode.desc;
                    String name = methodInsnNode.name;
                    Type[] argTypes = Type.getArgumentTypes(desc);
                    int paramCount = argTypes.length + 1;
                    int firstParameterIndex = frame.getStackSize() - paramCount;
                    if (InlineCodegenUtil.isInvokeOnLambda(owner, name)) {
                        SourceValue sourceValue = (SourceValue)frame.getStack(firstParameterIndex);
                        LambdaInfo lambdaInfo2 = MethodInlinerUtilKt.getLambdaIfExistsAndMarkInstructions(this, sourceValue, true, instructions, sources, toDelete);
                        this.invokeCalls.add(new InvokeCall(lambdaInfo2, currentFinallyDeep));
                    } else if (InlineCodegenUtil.isAnonymousConstructorCall(owner, name)) {
                        HashMap<Integer, LambdaInfo> lambdaMapping = new HashMap<Integer, LambdaInfo>();
                        int offset2 = 0;
                        boolean capturesAnonymousObjectThatMustBeRegenerated = false;
                        for (int i = 0; i < paramCount; ++i) {
                            SourceValue sourceValue = (SourceValue)frame.getStack(firstParameterIndex + i);
                            LambdaInfo lambdaInfo3 = MethodInlinerUtilKt.getLambdaIfExistsAndMarkInstructions(this, sourceValue, false, instructions, sources, toDelete);
                            if (lambdaInfo3 != null) {
                                lambdaMapping.put(offset2, lambdaInfo3);
                            } else if (i < argTypes.length && this.isAnonymousClassThatMustBeRegenerated(argTypes[i])) {
                                capturesAnonymousObjectThatMustBeRegenerated = true;
                            }
                            offset2 += i == 0 ? 1 : argTypes[i - 1].getSize();
                        }
                        this.transformations.add(this.buildConstructorInvocation(owner, desc, lambdaMapping, awaitClassReification, capturesAnonymousObjectThatMustBeRegenerated));
                        awaitClassReification = false;
                    } else if (this.inliningContext.isInliningLambda && ReifiedTypeInliner.Companion.isOperationReifiedMarker(cur)) {
                        ReificationArgument reificationArgument = ReifiedTypeInlinerKt.getReificationArgument((MethodInsnNode)cur);
                        String parameterName = reificationArgument.getParameterName();
                        this.result.getReifiedTypeParametersUsages().addUsedReifiedParameter(parameterName);
                    }
                } else if (cur.getOpcode() == 178) {
                    FieldInsnNode fieldInsnNode = (FieldInsnNode)cur;
                    String className2 = fieldInsnNode.owner;
                    if (InlineCodegenUtil.isAnonymousSingletonLoad(className2, fieldInsnNode.name)) {
                        this.transformations.add(new AnonymousObjectTransformationInfo(className2, awaitClassReification, this.isAlreadyRegenerated(className2), true, this.inliningContext.nameGenerator));
                        awaitClassReification = false;
                    } else if (InlineCodegenUtil.isWhenMappingAccess(className2, fieldInsnNode.name)) {
                        this.transformations.add(new WhenMappingTransformationInfo(className2, this.inliningContext.nameGenerator, this.isAlreadyRegenerated(className2), fieldInsnNode));
                    }
                } else if (cur.getOpcode() == 87 && (lambdaInfo = MethodInlinerUtilKt.getLambdaIfExistsAndMarkInstructions(this, top = (SourceValue)StackTransformationUtilsKt.top(frame), true, instructions, sources, toDelete)) != null) {
                    toDelete.add(cur);
                }
            }
            AbstractInsnNode prevNode = cur;
            if (frame != null || prevNode.getType() == 8) continue;
            toDelete.add(prevNode);
        }
        for (AbstractInsnNode insnNode : toDelete) {
            instructions.remove(insnNode);
        }
        List<TryCatchBlockNode> blocks = node.tryCatchBlocks;
        Iterator<TryCatchBlockNode> iterator2 = blocks.iterator();
        while (iterator2.hasNext()) {
            TryCatchBlockNode block = iterator2.next();
            if (!MethodInliner.isEmptyTryInterval(block)) continue;
            iterator2.remove();
        }
        MethodNode methodNode = node;
        if (methodNode == null) {
            MethodInliner.$$$reportNull$$$0(24);
        }
        return methodNode;
    }

    private void normalizeLocalReturns(@NotNull MethodNode node, @NotNull LabelOwner labelOwner) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(25);
        }
        if (labelOwner == null) {
            MethodInliner.$$$reportNull$$$0(26);
        }
        Frame<SourceValue>[] frames2 = this.analyzeMethodNodeBeforeInline(node);
        LocalReturnsNormalizer localReturnsNormalizer = new LocalReturnsNormalizer();
        AbstractInsnNode[] instructions = node.instructions.toArray();
        for (int i = 0; i < instructions.length; ++i) {
            AbstractInsnNode insnNode;
            Frame<SourceValue> frame = frames2[i];
            if (frame == null || !InlineCodegenUtil.isReturnOpcode((insnNode = instructions[i]).getOpcode())) continue;
            AbstractInsnNode insertBeforeInsn = insnNode;
            String labelName = InlineCodegenUtil.getMarkedReturnLabelOrNull(insnNode);
            if (labelName != null) {
                if (!labelOwner.isMyLabel(labelName)) continue;
                insertBeforeInsn = insnNode.getPrevious();
            }
            localReturnsNormalizer.addLocalReturnToTransform(insnNode, insertBeforeInsn, frame);
        }
        localReturnsNormalizer.transform(node);
    }

    private boolean isAnonymousClassThatMustBeRegenerated(@Nullable Type type2) {
        if (type2 == null || type2.getSort() != 10) {
            return false;
        }
        AnonymousObjectTransformationInfo info = this.inliningContext.findAnonymousObjectTransformationInfo(type2.getInternalName());
        return info != null && info.shouldRegenerate(true);
    }

    @NotNull
    private Frame<SourceValue>[] analyzeMethodNodeBeforeInline(@NotNull MethodNode node) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(27);
        }
        try {
            new FixStackWithLabelNormalizationMethodTransformer().transform("fake", node);
        }
        catch (Throwable e) {
            throw this.wrapException(e, node, "couldn't inline method call");
        }
        Frame<SourceValue>[] frameArray = MethodInliner.analyzeMethodNodeWithoutMandatoryTransformations(node);
        if (frameArray == null) {
            MethodInliner.$$$reportNull$$$0(28);
        }
        return frameArray;
    }

    private static Frame<SourceValue>[] analyzeMethodNodeWithoutMandatoryTransformations(@NotNull MethodNode node) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(29);
        }
        Analyzer<SourceValue> analyzer = new Analyzer<SourceValue>((Interpreter)new SourceInterpreter()){

            @Override
            @NotNull
            protected Frame<SourceValue> newFrame(int nLocals, int nStack) {
                Frame<SourceValue> frame = new Frame<SourceValue>(nLocals, nStack){

                    @Override
                    public void execute(@NotNull AbstractInsnNode insn, Interpreter<SourceValue> interpreter) throws AnalyzerException {
                        if (insn == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (insn.getOpcode() == 177) {
                            return;
                        }
                        super.execute(insn, interpreter);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/inline/MethodInliner$3$1", "execute"));
                    }
                };
                if (frame == null) {
                    3.$$$reportNull$$$0(0);
                }
                return frame;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner$3", "newFrame"));
            }
        };
        try {
            return analyzer.analyze("fake", node);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isEmptyTryInterval(@NotNull TryCatchBlockNode tryCatchBlockNode) {
        AbstractInsnNode end;
        if (tryCatchBlockNode == null) {
            MethodInliner.$$$reportNull$$$0(30);
        }
        LabelNode start = tryCatchBlockNode.start;
        for (end = tryCatchBlockNode.end; end != start && end instanceof LabelNode; end = end.getPrevious()) {
        }
        return start == end;
    }

    @NotNull
    private AnonymousObjectTransformationInfo buildConstructorInvocation(@NotNull String anonymousType, @NotNull String desc, @NotNull Map<Integer, LambdaInfo> lambdaMapping, boolean needReification, boolean capturesAnonymousObjectThatMustBeRegenerated) {
        if (anonymousType == null) {
            MethodInliner.$$$reportNull$$$0(31);
        }
        if (desc == null) {
            MethodInliner.$$$reportNull$$$0(32);
        }
        if (lambdaMapping == null) {
            MethodInliner.$$$reportNull$$$0(33);
        }
        boolean memoizeAnonymousObject = this.inliningContext.findAnonymousObjectTransformationInfo(anonymousType) == null;
        AnonymousObjectTransformationInfo info = new AnonymousObjectTransformationInfo(anonymousType, needReification, lambdaMapping, this.inliningContext.classRegeneration, this.isAlreadyRegenerated(anonymousType), desc, false, this.inliningContext.nameGenerator, capturesAnonymousObjectThatMustBeRegenerated);
        if (memoizeAnonymousObject) {
            this.inliningContext.getRoot().internalNameToAnonymousObjectTransformationInfo.put(anonymousType, info);
        }
        AnonymousObjectTransformationInfo anonymousObjectTransformationInfo = info;
        if (anonymousObjectTransformationInfo == null) {
            MethodInliner.$$$reportNull$$$0(34);
        }
        return anonymousObjectTransformationInfo;
    }

    private boolean isAlreadyRegenerated(@NotNull String owner) {
        if (owner == null) {
            MethodInliner.$$$reportNull$$$0(35);
        }
        return this.inliningContext.typeRemapper.hasNoAdditionalMapping(owner);
    }

    @Nullable
    LambdaInfo getLambdaIfExists(@Nullable AbstractInsnNode insnNode) {
        if (insnNode == null) {
            return null;
        }
        if (insnNode.getOpcode() == 25) {
            int varIndex = ((VarInsnNode)insnNode).var;
            return this.getLambdaIfExists(varIndex);
        }
        if (insnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
            if (fieldInsnNode.name.startsWith("$$$")) {
                return MethodInliner.findCapturedField(fieldInsnNode, this.nodeRemapper).getLambda();
            }
        }
        return null;
    }

    @Nullable
    private LambdaInfo getLambdaIfExists(int varIndex) {
        if (varIndex < this.parameters.getArgsSizeOnStack()) {
            return this.parameters.getParameterByDeclarationSlot(varIndex).getLambda();
        }
        return null;
    }

    private static void removeClosureAssertions(@NotNull MethodNode node) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(36);
        }
        AbstractInsnNode cur = node.instructions.getFirst();
        while (cur != null && cur.getNext() != null) {
            AbstractInsnNode next = cur.getNext();
            if (next.getType() == 5) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)next;
                if (methodInsnNode.name.equals("checkParameterIsNotNull") && methodInsnNode.owner.equals("kotlin/jvm/internal/Intrinsics")) {
                    AbstractInsnNode prev = cur.getPrevious();
                    assert (cur.getOpcode() == 18) : "checkParameterIsNotNull should go after LDC but " + cur;
                    assert (prev.getOpcode() == 25) : "checkParameterIsNotNull should be invoked on local var but " + prev;
                    node.instructions.remove(prev);
                    node.instructions.remove(cur);
                    cur = next.getNext();
                    node.instructions.remove(next);
                    next = cur;
                }
            }
            cur = next;
        }
    }

    private void transformCaptured(@NotNull MethodNode node) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(37);
        }
        if (this.nodeRemapper.isRoot()) {
            return;
        }
        for (AbstractInsnNode cur = node.instructions.getFirst(); cur != null; cur = cur.getNext()) {
            List<AbstractInsnNode> accessChain;
            AbstractInsnNode insnNode;
            int varIndex;
            if (!(cur instanceof VarInsnNode) || cur.getOpcode() != 25 || (varIndex = ((VarInsnNode)cur).var) != 0 && !this.nodeRemapper.processNonAload0FieldAccessChains(this.getLambdaIfExists(varIndex) != null) || (insnNode = this.nodeRemapper.foldFieldAccessChainIfNeeded(accessChain = MethodInliner.getCapturedFieldAccessChain((VarInsnNode)cur), node)) == null) continue;
            cur = insnNode;
        }
    }

    private static void transformFinallyDeepIndex(@NotNull MethodNode node, int finallyDeepShift) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(38);
        }
        if (finallyDeepShift == 0) {
            return;
        }
        for (AbstractInsnNode cur = node.instructions.getFirst(); cur != null; cur = cur.getNext()) {
            if (!(cur instanceof MethodInsnNode) || !InlineCodegenUtil.isFinallyMarker(cur)) continue;
            AbstractInsnNode constant = cur.getPrevious();
            int curDeep = InlineCodegenUtil.getConstant(constant);
            node.instructions.insert(constant, new LdcInsnNode((Object)(curDeep + finallyDeepShift)));
            node.instructions.remove(constant);
        }
    }

    @NotNull
    private static List<AbstractInsnNode> getCapturedFieldAccessChain(@NotNull VarInsnNode aload0) {
        if (aload0 == null) {
            MethodInliner.$$$reportNull$$$0(39);
        }
        ArrayList<AbstractInsnNode> fieldAccessChain = new ArrayList<AbstractInsnNode>();
        fieldAccessChain.add(aload0);
        AbstractInsnNode next = aload0.getNext();
        while (next != null && next instanceof FieldInsnNode || next instanceof LabelNode) {
            if (next instanceof LabelNode) {
                next = next.getNext();
                continue;
            }
            fieldAccessChain.add(next);
            if (!"this$0".equals(((FieldInsnNode)next).name)) break;
            next = next.getNext();
        }
        ArrayList<AbstractInsnNode> arrayList = fieldAccessChain;
        if (arrayList == null) {
            MethodInliner.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    private static void putStackValuesIntoLocals(@NotNull List<Type> directOrder, int shift, @NotNull InstructionAdapter iv, @NotNull String descriptor2) {
        if (directOrder == null) {
            MethodInliner.$$$reportNull$$$0(41);
        }
        if (iv == null) {
            MethodInliner.$$$reportNull$$$0(42);
        }
        if (descriptor2 == null) {
            MethodInliner.$$$reportNull$$$0(43);
        }
        Type[] actualParams = Type.getArgumentTypes(descriptor2);
        assert (actualParams.length == directOrder.size()) : "Number of expected and actual params should be equals!";
        int size = 0;
        for (Type next : directOrder) {
            size += next.getSize();
        }
        shift += size;
        int index2 = directOrder.size();
        for (Type next : Lists.reverse(directOrder)) {
            Type typeOnStack;
            shift -= next.getSize();
            if (!(typeOnStack = actualParams[--index2]).equals(next)) {
                StackValue.onStack(typeOnStack).put(next, iv);
            }
            iv.store(shift, next);
        }
    }

    @NotNull
    private RuntimeException wrapException(@NotNull Throwable originalException, @NotNull MethodNode node, @NotNull String errorSuffix) {
        if (originalException == null) {
            MethodInliner.$$$reportNull$$$0(44);
        }
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(45);
        }
        if (errorSuffix == null) {
            MethodInliner.$$$reportNull$$$0(46);
        }
        if (originalException instanceof InlineException) {
            InlineException inlineException = new InlineException(this.errorPrefix + ": " + errorSuffix, originalException);
            if (inlineException == null) {
                MethodInliner.$$$reportNull$$$0(47);
            }
            return inlineException;
        }
        InlineException inlineException = new InlineException(this.errorPrefix + ": " + errorSuffix + "\nCause: " + InlineCodegenUtil.getNodeText(node), originalException);
        if (inlineException == null) {
            MethodInliner.$$$reportNull$$$0(48);
        }
        return inlineException;
    }

    @NotNull
    public static List<PointForExternalFinallyBlocks> processReturns(@NotNull MethodNode node, @NotNull LabelOwner labelOwner, boolean remapReturn, @Nullable Label endLabel) {
        if (node == null) {
            MethodInliner.$$$reportNull$$$0(49);
        }
        if (labelOwner == null) {
            MethodInliner.$$$reportNull$$$0(50);
        }
        if (!remapReturn) {
            List<PointForExternalFinallyBlocks> list2 = Collections.emptyList();
            if (list2 == null) {
                MethodInliner.$$$reportNull$$$0(51);
            }
            return list2;
        }
        ArrayList<PointForExternalFinallyBlocks> result2 = new ArrayList<PointForExternalFinallyBlocks>();
        InsnList instructions = node.instructions;
        for (AbstractInsnNode insnNode = instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!InlineCodegenUtil.isReturnOpcode(insnNode.getOpcode())) continue;
            boolean isLocalReturn = true;
            String labelName = InlineCodegenUtil.getMarkedReturnLabelOrNull(insnNode);
            if (labelName != null && (isLocalReturn = labelOwner.isMyLabel(labelName))) {
                instructions.remove(insnNode.getPrevious());
            }
            if (isLocalReturn && endLabel != null) {
                LabelNode labelNode = (LabelNode)endLabel.info;
                JumpInsnNode jumpInsnNode = new JumpInsnNode(167, labelNode);
                instructions.insert(insnNode, jumpInsnNode);
                instructions.remove(insnNode);
                insnNode = jumpInsnNode;
            }
            LabelNode label = new LabelNode();
            instructions.insert(insnNode, label);
            result2.add(new PointForExternalFinallyBlocks(MethodInliner.getInstructionToInsertFinallyBefore(insnNode, isLocalReturn), InlineCodegenUtil.getReturnType(insnNode.getOpcode()), label));
        }
        ArrayList<PointForExternalFinallyBlocks> arrayList = result2;
        if (arrayList == null) {
            MethodInliner.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    @NotNull
    private static AbstractInsnNode getInstructionToInsertFinallyBefore(@NotNull AbstractInsnNode nonLocalReturnOrJump, boolean isLocal) {
        if (nonLocalReturnOrJump == null) {
            MethodInliner.$$$reportNull$$$0(53);
        }
        AbstractInsnNode abstractInsnNode = isLocal ? nonLocalReturnOrJump : nonLocalReturnOrJump.getPrevious();
        if (abstractInsnNode == null) {
            MethodInliner.$$$reportNull$$$0(54);
        }
        return abstractInsnNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 34: 
            case 40: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 34: 
            case 40: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inliningContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRemapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPrefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceMapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlineCallSiteInfo";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remapper";
                break;
            }
            case 9: 
            case 13: 
            case 23: 
            case 26: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelOwner";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 34: 
            case 40: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/inline/MethodInliner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldRemapper";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryCatchBlockNode";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaMapping";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aload0";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directOrder";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iv";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalException";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorSuffix";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonLocalReturnOrJump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/MethodInliner";
                break;
            }
            case 10: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doInline";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findCapturedField";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareNode";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "markPlacesForInlineAndRemoveInlinable";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeMethodNodeBeforeInline";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConstructorInvocation";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedFieldAccessChain";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapException";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "processReturns";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructionToInsertFinallyBefore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doInline";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 34: 
            case 40: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findCapturedField";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepareNode";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "markPlacesForInlineAndRemoveInlinable";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "normalizeLocalReturns";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethodNodeBeforeInline";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethodNodeWithoutMandatoryTransformations";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyTryInterval";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildConstructorInvocation";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyRegenerated";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeClosureAssertions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "transformCaptured";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "transformFinallyDeepIndex";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedFieldAccessChain";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "putStackValuesIntoLocals";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "wrapException";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processReturns";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getInstructionToInsertFinallyBefore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 28: 
            case 34: 
            case 40: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PointForExternalFinallyBlocks {
        public final AbstractInsnNode beforeIns;
        public final Type returnType;
        public final LabelNode finallyIntervalEnd;

        public PointForExternalFinallyBlocks(@NotNull AbstractInsnNode beforeIns, @NotNull Type returnType, @NotNull LabelNode finallyIntervalEnd) {
            if (beforeIns == null) {
                PointForExternalFinallyBlocks.$$$reportNull$$$0(0);
            }
            if (returnType == null) {
                PointForExternalFinallyBlocks.$$$reportNull$$$0(1);
            }
            if (finallyIntervalEnd == null) {
                PointForExternalFinallyBlocks.$$$reportNull$$$0(2);
            }
            this.beforeIns = beforeIns;
            this.returnType = returnType;
            this.finallyIntervalEnd = finallyIntervalEnd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "beforeIns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "returnType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finallyIntervalEnd";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/inline/MethodInliner$PointForExternalFinallyBlocks";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LocalReturnsNormalizer {
        private final List<LocalReturn> localReturns = new SmartList<LocalReturn>();
        private int returnVariableSize = 0;
        private int returnOpcode = -1;

        private LocalReturnsNormalizer() {
        }

        private void addLocalReturnToTransform(@NotNull AbstractInsnNode returnInsn, @NotNull AbstractInsnNode insertBeforeInsn, @NotNull Frame<SourceValue> sourceValueFrame) {
            if (returnInsn == null) {
                LocalReturnsNormalizer.$$$reportNull$$$0(0);
            }
            if (insertBeforeInsn == null) {
                LocalReturnsNormalizer.$$$reportNull$$$0(1);
            }
            if (sourceValueFrame == null) {
                LocalReturnsNormalizer.$$$reportNull$$$0(2);
            }
            assert (InlineCodegenUtil.isReturnOpcode(returnInsn.getOpcode())) : "return instruction expected";
            assert (this.returnOpcode < 0 || this.returnOpcode == returnInsn.getOpcode()) : "Return op should be " + Printer.OPCODES[this.returnOpcode] + ", got " + Printer.OPCODES[returnInsn.getOpcode()];
            this.returnOpcode = returnInsn.getOpcode();
            this.localReturns.add(new LocalReturn(returnInsn, insertBeforeInsn, sourceValueFrame));
            if (returnInsn.getOpcode() != 177) {
                this.returnVariableSize = returnInsn.getOpcode() == 173 || returnInsn.getOpcode() == 175 ? 2 : 1;
            }
        }

        public void transform(@NotNull MethodNode methodNode) {
            if (methodNode == null) {
                LocalReturnsNormalizer.$$$reportNull$$$0(3);
            }
            int returnVariableIndex = -1;
            if (this.returnVariableSize > 0) {
                returnVariableIndex = methodNode.maxLocals;
                methodNode.maxLocals += this.returnVariableSize;
            }
            for (LocalReturn localReturn : this.localReturns) {
                localReturn.transform(methodNode.instructions, returnVariableIndex);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnInsn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertBeforeInsn";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceValueFrame";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNode";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addLocalReturnToTransform";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "transform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class LocalReturn {
            private final AbstractInsnNode returnInsn;
            private final AbstractInsnNode insertBeforeInsn;
            private final Frame<SourceValue> frame;

            public LocalReturn(@NotNull AbstractInsnNode returnInsn, @NotNull AbstractInsnNode insertBeforeInsn, @NotNull Frame<SourceValue> frame) {
                if (returnInsn == null) {
                    LocalReturn.$$$reportNull$$$0(0);
                }
                if (insertBeforeInsn == null) {
                    LocalReturn.$$$reportNull$$$0(1);
                }
                if (frame == null) {
                    LocalReturn.$$$reportNull$$$0(2);
                }
                this.returnInsn = returnInsn;
                this.insertBeforeInsn = insertBeforeInsn;
                this.frame = frame;
            }

            public void transform(@NotNull InsnList insnList, int returnVariableIndex) {
                int actualStackSize;
                boolean isReturnWithValue;
                int expectedStackSize;
                if (insnList == null) {
                    LocalReturn.$$$reportNull$$$0(3);
                }
                if ((expectedStackSize = (isReturnWithValue = this.returnInsn.getOpcode() != 177) ? 1 : 0) == (actualStackSize = this.frame.getStackSize())) {
                    return;
                }
                int stackSize = actualStackSize;
                if (isReturnWithValue) {
                    int storeOpcode = 54 + this.returnInsn.getOpcode() - 172;
                    insnList.insertBefore(this.insertBeforeInsn, new VarInsnNode(storeOpcode, returnVariableIndex));
                    --stackSize;
                }
                while (stackSize > 0) {
                    int stackElementSize = this.frame.getStack(stackSize - 1).getSize();
                    int popOpcode = stackElementSize == 1 ? 87 : 88;
                    insnList.insertBefore(this.insertBeforeInsn, new InsnNode(popOpcode));
                    --stackSize;
                }
                if (isReturnWithValue) {
                    int loadOpcode = 21 + this.returnInsn.getOpcode() - 172;
                    insnList.insertBefore(this.insertBeforeInsn, new VarInsnNode(loadOpcode, returnVariableIndex));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "returnInsn";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "insertBeforeInsn";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "frame";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "insnList";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer$LocalReturn";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transform";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

