/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.npw.FormFactor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DeviceMenuAction
extends FlatComboAction {
    private static final boolean LIST_RECENT_DEVICES = false;
    private final ConfigurationHolder myRenderContext;

    public DeviceMenuAction(@NotNull ConfigurationHolder renderContext) {
        if (renderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/DeviceMenuAction", "<init>"));
        }
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Device in Editor");
        presentation.setIcon(AndroidIcons.NeleIcons.VirtualDevice);
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Device device = configuration.getDevice();
            String label = DeviceMenuAction.getDeviceLabel(device, true);
            presentation.setText(label);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public static String getDeviceLabel(Device device, boolean brief) {
        if (device == null) {
            return "";
        }
        String name = device.getDisplayName();
        if (brief) {
            int end;
            int begin;
            int nexus = name.indexOf("Nexus");
            if (nexus != -1 && (begin = name.indexOf(40)) != -1 && (end = name.indexOf(41, ++begin)) != -1) {
                if (name.equals("Nexus 7 (2012)")) {
                    return "Nexus 7";
                }
                return name.substring(begin, end).trim();
            }
            String skipPrefix = "Android ";
            name = StringUtil.trimStart((String)name, (String)skipPrefix);
        }
        return name;
    }

    public Icon getDeviceClassIcon(Device device) {
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return AndroidIcons.NeleIcons.Wear;
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return AndroidIcons.NeleIcons.Tv;
            }
            if (DeviceArtPainter.isTablet(device)) {
                return AndroidIcons.NeleIcons.Tablet;
            }
        }
        return AndroidIcons.NeleIcons.Phone;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/DeviceMenuAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }
        Device current = configuration.getDevice();
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        List<Device> deviceList = configurationManager.getDevices();
        AndroidFacet facet = AndroidFacet.getInstance(configurationManager.getModule());
        if (facet == null) {
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/DeviceMenuAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }
        if (!deviceList.isEmpty()) {
            TreeMap<String, Object> manufacturers = new TreeMap<String, Object>();
            for (Device device : deviceList) {
                Object devices;
                if (manufacturers.containsKey(device.getManufacturer())) {
                    devices = (List)manufacturers.get(device.getManufacturer());
                } else {
                    devices = new ArrayList();
                    manufacturers.put(device.getManufacturer(), devices);
                }
                devices.add(device);
            }
            ArrayList<Device> nexus = new ArrayList<Device>();
            EnumMap deviceMap = Maps.newEnumMap(FormFactor.class);
            for (FormFactor factor : FormFactor.values()) {
                deviceMap.put(factor, Lists.newArrayList());
            }
            for (List list : manufacturers.values()) {
                for (Device device : list) {
                    if (HardwareConfigHelper.isNexus((Device)device) && !device.getManufacturer().equals("Generic") && !HardwareConfigHelper.isWear((Device)device) && !HardwareConfigHelper.isTv((Device)device)) {
                        nexus.add(device);
                        continue;
                    }
                    ((List)deviceMap.get((Object)FormFactor.getFormFactor(device))).add(device);
                }
            }
            HardwareConfigHelper.sortDevicesByScreenSize(nexus);
            for (List list : DeviceMenuAction.splitDevicesByScreenSize(nexus)) {
                this.addNexusDeviceSection(group, current, list);
                group.addSeparator();
            }
            this.addDeviceSection(group, current, deviceMap, false, FormFactor.WEAR);
            group.addSeparator();
            this.addDeviceSection(group, current, deviceMap, false, FormFactor.TV);
            group.addSeparator();
            AvdManager avdManager = facet.getAvdManagerSilently();
            if (avdManager != null) {
                boolean bl;
                boolean bl2 = false;
                boolean first = true;
                for (AvdInfo avd : avdManager.getValidAvds()) {
                    Device device = configurationManager.createDeviceForAvd(avd);
                    if (device == null) continue;
                    String avdName = "AVD: " + avd.getName();
                    boolean selected = current != null && (current.getDisplayName().equals(avdName) || current.getId().equals(avdName));
                    Icon icon = first ? this.getDeviceClassIcon(device) : null;
                    group.add((AnAction)new SetDeviceAction(this.myRenderContext, avdName, device, icon, selected));
                    first = false;
                    bl = true;
                }
                if (bl) {
                    group.addSeparator();
                }
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup("_Generic Phones and Tablets", true);
            HardwareConfigHelper.sortDevicesByScreenSize((List)((List)deviceMap.get((Object)FormFactor.MOBILE)));
            this.addDeviceSection(defaultActionGroup, current, deviceMap, true, FormFactor.MOBILE);
            group.add((AnAction)defaultActionGroup);
        }
        group.add((AnAction)new RunAndroidAvdManagerAction("Add Device Definition..."));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/DeviceMenuAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    private static List<List<Device>> splitDevicesByScreenSize(List<Device> devices) {
        ArrayList lists = Lists.newArrayList();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)6);
        int prevGroup = -1;
        for (Device device : devices) {
            int group = DeviceMenuAction.sizeGroup(device);
            if (group != prevGroup) {
                prevGroup = group;
                list = Lists.newArrayListWithExpectedSize((int)6);
                lists.add(list);
            }
            list.add(device);
        }
        return lists;
    }

    private static int sizeGroup(Device device) {
        double diagonalLength = device.getDefaultHardware().getScreen().getDiagonalLength();
        if (diagonalLength < 5.0) {
            return 1;
        }
        if (diagonalLength < 6.5) {
            return 2;
        }
        return 3;
    }

    private void addNexusDeviceSection(@NotNull DefaultActionGroup group, Device current, @NotNull List<Device> devices) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/DeviceMenuAction", "addNexusDeviceSection"));
        }
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/configurations/DeviceMenuAction", "addNexusDeviceSection"));
        }
        boolean first = true;
        for (Device device : devices) {
            String label = this.getLabel(device, true);
            Icon icon = first ? this.getDeviceClassIcon(device) : null;
            first = false;
            group.add((AnAction)new SetDeviceAction(this.myRenderContext, label, device, icon, current == device));
        }
    }

    private void addDeviceSection(@NotNull DefaultActionGroup group, Device current, @NotNull Map<FormFactor, List<Device>> deviceMap, boolean reverse, @NotNull FormFactor factor) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/DeviceMenuAction", "addDeviceSection"));
        }
        if (deviceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceMap", "com/android/tools/idea/configurations/DeviceMenuAction", "addDeviceSection"));
        }
        if (factor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factor", "com/android/tools/idea/configurations/DeviceMenuAction", "addDeviceSection"));
        }
        List<Device> generic = deviceMap.get((Object)factor);
        if (reverse) {
            Collections.reverse(generic);
        }
        boolean first = true;
        for (Device device : generic) {
            String label = this.getLabel(device, HardwareConfigHelper.isNexus((Device)device));
            Icon icon = first ? this.getDeviceClassIcon(device) : null;
            group.add((AnAction)new SetDeviceAction(this.myRenderContext, label, device, icon, current == device));
            first = false;
        }
    }

    private String getLabel(Device device, boolean isNexus) {
        VirtualFile better;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (better = ConfigurationMatcher.getBetterMatch(configuration, device, null, null, null)) != null) {
            return ConfigurationAction.getBetterMatchLabel(device.getDisplayName(), better, configuration.getFile());
        }
        return isNexus ? HardwareConfigHelper.getNexusMenuLabel((Device)device) : HardwareConfigHelper.getGenericLabel((Device)device);
    }

    private class SetDeviceAction
    extends ConfigurationAction {
        private final Device myDevice;

        public SetDeviceAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, Device device, Icon defaultIcon, boolean select) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/DeviceMenuAction$SetDeviceAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/DeviceMenuAction$SetDeviceAction", "<init>"));
            }
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/configurations/DeviceMenuAction$SetDeviceAction", "<init>"));
            }
            super(renderContext, title);
            this.myDevice = device;
            if (select) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            } else if (ConfigurationAction.isBetterMatchLabel(title)) {
                this.getTemplatePresentation().setIcon(ConfigurationAction.getBetterMatchIcon());
            } else if (defaultIcon != null) {
                this.getTemplatePresentation().setIcon(defaultIcon);
            }
        }

        @Override
        protected void updatePresentation() {
            DeviceMenuAction.this.updatePresentation(DeviceMenuAction.this.getTemplatePresentation());
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            String name;
            VirtualFile file;
            String newState;
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/DeviceMenuAction$SetDeviceAction", "updateConfiguration"));
            }
            Device prevDevice = configuration.getDevice();
            State prevState = configuration.getDeviceState();
            String string = newState = prevState != null ? prevState.getName() : null;
            if (prevDevice != null && prevState != null && prevState.isDefaultState() && !this.myDevice.getDefaultState().getName().equals(prevState.getName()) && configuration.getEditedConfig().getScreenOrientationQualifier() == null && (file = configuration.getFile()) != null && ConfigurationMatcher.getBetterMatch(configuration, this.myDevice, name = this.myDevice.getDefaultState().getName(), null, null) == null) {
                newState = name;
            }
            if (newState != null) {
                configuration.setDeviceStateName(newState);
            }
            if (commit) {
                configuration.getConfigurationManager().selectDevice(this.myDevice);
            } else {
                configuration.setDevice(this.myDevice, true);
            }
        }
    }
}

