/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.LightGeneratedComponentClass;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingComponentClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private CachedValue<List<PsiClass>> myClasses;

    public DataBindingComponentClassFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
        this.myClasses = CachedValuesManager.getManager((Project)component.getProject()).createCachedValue(() -> {
            ArrayList classes = Lists.newArrayList();
            for (AndroidFacet facet : this.myComponent.getDataBindingEnabledFacets()) {
                if (facet.isLibraryProject()) continue;
                classes.add(new LightGeneratedComponentClass(PsiManager.getInstance((Project)component.getProject()), facet));
            }
            return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{this.myComponent, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "findClass"));
        }
        if (!this.isEnabled() || !"android.databinding.DataBindingComponent".equals(qualifiedName)) {
            return null;
        }
        return (PsiClass)Iterables.tryFind((Iterable)((Iterable)this.myClasses.getValue()), input -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "lambda$findClass$1"));
            }
            return DataBindingComponentClassFinder.check(input, scope);
        }).orNull();
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "findClasses"));
        }
        if (!this.isEnabled() || !"android.databinding.DataBindingComponent".equals(qualifiedName)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "findClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        Iterable filtered = Iterables.filter((Iterable)((Iterable)this.myClasses.getValue()), input -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "lambda$findClasses$2"));
            }
            return DataBindingComponentClassFinder.check(input, scope);
        });
        if (filtered.iterator().hasNext()) {
            PsiClass[] psiClassArray = (PsiClass[])Iterables.toArray((Iterable)filtered, PsiClass.class);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "findClasses"));
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "findClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    private static boolean check(@Nullable PsiClass psiClass, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingComponentClassFinder", "check"));
        }
        return psiClass != null && psiClass.getProject() == scope.getProject();
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }
}

