/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ProjectResourceCachedValueProvider;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingPackageFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private final CachedValue<Map<String, PsiPackage>> myPackageCache;

    public DataBindingPackageFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
        this.myPackageCache = CachedValuesManager.getManager((Project)this.myComponent.getProject()).createCachedValue((CachedValueProvider)new ProjectResourceCachedValueProvider<Map<String, PsiPackage>, Set<String>>(this.myComponent, new ModificationTracker[0]){

            @Override
            @NotNull
            protected Map<String, PsiPackage> merge(List<Set<String>> results) {
                HashMap merged = Maps.newHashMap();
                for (Set<String> result : results) {
                    for (String qualifiedPackage : result) {
                        if (merged.containsKey(qualifiedPackage)) continue;
                        merged.put(qualifiedPackage, DataBindingPackageFinder.this.myComponent.getOrCreateDataBindingPsiPackage(qualifiedPackage));
                    }
                }
                HashMap hashMap = merged;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingPackageFinder$1", "merge"));
                }
                return hashMap;
            }

            @Override
            ResourceCacheValueProvider<Set<String>> createCacheProvider(AndroidFacet facet) {
                return new ResourceCacheValueProvider<Set<String>>(facet, new ModificationTracker[0]){

                    @Override
                    Set<String> doCompute() {
                        LocalResourceRepository moduleResources = this.getFacet().getModuleResources(true);
                        Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
                        if (dataBindingResourceFiles == null) {
                            return Collections.emptySet();
                        }
                        HashSet result = Sets.newHashSet();
                        for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                            result.add(info.getPackageName());
                        }
                        return result;
                    }

                    @Override
                    Set<String> defaultValue() {
                        return Collections.emptySet();
                    }
                };
            }
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/databinding/DataBindingPackageFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingPackageFinder", "findClass"));
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/databinding/DataBindingPackageFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingPackageFinder", "findClasses"));
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingPackageFinder", "findClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/databinding/DataBindingPackageFinder", "findPackage"));
        }
        if (!this.isEnabled()) {
            return null;
        }
        return (PsiPackage)((Map)this.myPackageCache.getValue()).get(qualifiedName);
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }
}

