/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.rendering.Locale;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResource {
    @NotNull
    private String myKey;
    @NotNull
    private ResourceItemEntry myDefaultValue;
    private boolean myTranslatable;
    @NotNull
    private final Map<Locale, ResourceItemEntry> myLocaleToTranslationMap;

    StringResource(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResource", "<init>"));
        }
        this.myTranslatable = true;
        this.myLocaleToTranslationMap = new HashMap<Locale, ResourceItemEntry>();
        this.myKey = key;
        this.myDefaultValue = new ResourceItemEntry();
    }

    @NotNull
    String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResource", "getKey"));
        }
        return string;
    }

    void setKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResource", "setKey"));
        }
        this.myKey = key;
    }

    @Nullable
    ResourceItem getDefaultValueAsResourceItem() {
        return this.myDefaultValue.myResourceItem;
    }

    @NotNull
    public String getDefaultValueAsString() {
        String string = this.myDefaultValue.myString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResource", "getDefaultValueAsString"));
        }
        return string;
    }

    void setDefaultValue(@NotNull ResourceItem resourceItem, @NotNull String string) {
        if (resourceItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceItem", "com/android/tools/idea/editors/strings/StringResource", "setDefaultValue"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/android/tools/idea/editors/strings/StringResource", "setDefaultValue"));
        }
        this.myDefaultValue = new ResourceItemEntry(resourceItem, string);
    }

    void removeDefaultValue() {
        this.myDefaultValue = new ResourceItemEntry();
    }

    public boolean isTranslatable() {
        return this.myTranslatable;
    }

    void setTranslatable(boolean translatable) {
        this.myTranslatable = translatable;
    }

    @Nullable
    ResourceItem getTranslationAsResourceItem(@NotNull Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/editors/strings/StringResource", "getTranslationAsResourceItem"));
        }
        ResourceItemEntry resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        return resourceItemEntry == null ? null : resourceItemEntry.myResourceItem;
    }

    @NotNull
    public String getTranslationAsString(@NotNull Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/editors/strings/StringResource", "getTranslationAsString"));
        }
        ResourceItemEntry resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        String string = resourceItemEntry == null ? "" : resourceItemEntry.myString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResource", "getTranslationAsString"));
        }
        return string;
    }

    void putTranslation(@NotNull Locale locale, @NotNull ResourceItem resourceItem, @NotNull String string) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/editors/strings/StringResource", "putTranslation"));
        }
        if (resourceItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceItem", "com/android/tools/idea/editors/strings/StringResource", "putTranslation"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/android/tools/idea/editors/strings/StringResource", "putTranslation"));
        }
        this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry(resourceItem, string));
    }

    void removeTranslation(@NotNull Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/editors/strings/StringResource", "removeTranslation"));
        }
        this.myLocaleToTranslationMap.remove(locale);
    }

    @NotNull
    Collection<Locale> getTranslatedLocales() {
        Set<Locale> set = this.myLocaleToTranslationMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResource", "getTranslatedLocales"));
        }
        return set;
    }

    boolean isTranslationMissing(@NotNull Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/editors/strings/StringResource", "isTranslationMissing"));
        }
        ResourceItemEntry item = this.myLocaleToTranslationMap.get(locale);
        if (StringResource.isTranslationMissing(item) && locale.hasRegion()) {
            locale = Locale.create(locale.qualifier.getLanguage());
            item = this.myLocaleToTranslationMap.get(locale);
        }
        return StringResource.isTranslationMissing(item);
    }

    private static boolean isTranslationMissing(@Nullable ResourceItemEntry item) {
        return item == null || item.myString.isEmpty();
    }

    private static final class ResourceItemEntry {
        @Nullable
        private final ResourceItem myResourceItem;
        @NotNull
        private final String myString;

        public ResourceItemEntry() {
            this.myResourceItem = null;
            this.myString = "";
        }

        private ResourceItemEntry(@NotNull ResourceItem resourceItem, @NotNull String string) {
            if (resourceItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceItem", "com/android/tools/idea/editors/strings/StringResource$ResourceItemEntry", "<init>"));
            }
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/android/tools/idea/editors/strings/StringResource$ResourceItemEntry", "<init>"));
            }
            this.myResourceItem = resourceItem;
            this.myString = string;
        }
    }
}

