/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.vmtrace;

import com.android.tools.idea.editors.vmtrace.treemodel.VmStatsTreeTableModel;
import com.android.tools.idea.editors.vmtrace.treemodel.VmStatsTreeUtils;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.SearchResult;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.android.tools.perflib.vmtrace.viz.TraceViewCanvas;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceViewPanel {
    @NonNls
    public static DataKey<TraceViewPanel> KEY = DataKey.create((String)"android.traceview.panel");
    @NonNls
    private static final String CARD_FIND = "FIND";
    @NonNls
    private static final String CARD_DEFAULT = "DEFAULT";
    @NonNls
    private static final String MAIN_THREAD_NAME = "main";
    private final Project myProject;
    private JPanel myContainer;
    private JPanel myHeaderPanel;
    private TraceViewCanvas myTraceViewCanvas;
    private TreeTable myTreeTable;
    private JPanel myDefaultHeaderPanel;
    private JComboBox myThreadCombo;
    private JComboBox myRenderClockSelectorCombo;
    private JPanel myFindPanel;
    private JPanel myFindFieldWrapper;
    private SearchTextField mySearchField;
    private JLabel myCloseLabel;
    private JBLabel myResultsLabel;
    private JLabel mySearchLabel;
    private JBSplitter mySplitter;
    private JLabel myZoomFitLabel;
    private JCheckBox myUseInclusiveTimeForColoring;
    private static final String[] ourRenderClockOptions = new String[]{"Wall Clock Time", "Thread Time"};
    private static final ClockType[] ourRenderClockTypes = new ClockType[]{ClockType.GLOBAL, ClockType.THREAD};
    private VmTraceData myTraceData;
    private VmStatsTreeTableModel myVmStatsTreeTableModel;

    public TraceViewPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myRenderClockSelectorCombo.setModel(new DefaultComboBoxModel<String>(ourRenderClockOptions));
        this.myRenderClockSelectorCombo.setSelectedIndex(0);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == TraceViewPanel.this.myThreadCombo) {
                    ThreadInfo selectedThread = (ThreadInfo)TraceViewPanel.this.myThreadCombo.getSelectedItem();
                    TraceViewPanel.this.myTraceViewCanvas.displayThread(selectedThread);
                    TraceViewPanel.this.myVmStatsTreeTableModel.setThread(selectedThread);
                } else if (e.getSource() == TraceViewPanel.this.myRenderClockSelectorCombo) {
                    TraceViewPanel.this.myTraceViewCanvas.setRenderClock(TraceViewPanel.this.getCurrentRenderClock());
                    TraceViewPanel.this.myVmStatsTreeTableModel.setClockType(TraceViewPanel.this.getCurrentRenderClock());
                } else if (e.getSource() == TraceViewPanel.this.myUseInclusiveTimeForColoring) {
                    TraceViewPanel.this.myTraceViewCanvas.setUseInclusiveTimeForColorAssignment(TraceViewPanel.this.myUseInclusiveTimeForColoring.isSelected());
                }
            }
        };
        this.myThreadCombo.addActionListener(l);
        this.myRenderClockSelectorCombo.addActionListener(l);
        this.myUseInclusiveTimeForColoring.addActionListener(l);
        this.myUseInclusiveTimeForColoring.setOpaque(false);
    }

    private SearchTextField createSearchField() {
        SearchTextField stf = new SearchTextField(true);
        stf.setOpaque(false);
        stf.setEnabled(true);
        Utils.setSmallerFont((JComponent)stf);
        stf.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                TraceViewPanel.this.searchTextChanged(this.getText(e));
            }

            private String getText(DocumentEvent e) {
                try {
                    return e.getDocument().getText(0, e.getDocument().getLength());
                }
                catch (BadLocationException e1) {
                    return "";
                }
            }
        });
        JBTextField editorTextField = stf.getTextEditor();
        editorTextField.setMinimumSize(new Dimension(JBUI.scale((int)200), -1));
        editorTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraceViewPanel.this.closeSearchComponent();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        return stf;
    }

    private void searchTextChanged(@Nullable String pattern) {
        if (StringUtil.isEmpty((String)pattern)) {
            this.myTraceViewCanvas.setHighlightMethods(null);
            this.myResultsLabel.setText("");
            return;
        }
        ThreadInfo thread = (ThreadInfo)this.myThreadCombo.getSelectedItem();
        SearchResult results = this.myTraceData.searchFor(pattern, thread);
        this.myTraceViewCanvas.setHighlightMethods(results.getMethods());
        String result = String.format("%1$d %2$s, %3$d %4$s", results.getMethods().size(), StringUtil.pluralize((String)"method", (int)results.getMethods().size()), results.getInstances().size(), StringUtil.pluralize((String)"instance", (int)results.getInstances().size()));
        this.myResultsLabel.setText(result);
    }

    public void setTrace(@NotNull VmTraceData trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/android/tools/idea/editors/vmtrace/TraceViewPanel", "setTrace"));
        }
        this.myTraceData = trace;
        List threads = trace.getThreads(true);
        if (threads.isEmpty()) {
            return;
        }
        ThreadInfo defaultThread = (ThreadInfo)Iterables.find((Iterable)threads, (Predicate)new Predicate<ThreadInfo>(){

            public boolean apply(ThreadInfo input) {
                return TraceViewPanel.MAIN_THREAD_NAME.equals(input.getName());
            }
        }, threads.get(0));
        this.myTraceViewCanvas.setTrace(trace, defaultThread, this.getCurrentRenderClock());
        this.myThreadCombo.setModel(new DefaultComboBoxModel<Object>(threads.toArray()));
        this.myThreadCombo.setSelectedItem(defaultThread);
        this.myThreadCombo.setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                String name = value instanceof ThreadInfo ? ((ThreadInfo)value).getName() : value.toString();
                this.append(name);
            }
        });
        this.myThreadCombo.setEnabled(true);
        this.myRenderClockSelectorCombo.setEnabled(true);
        this.myVmStatsTreeTableModel.setTraceData(trace, defaultThread);
        this.myVmStatsTreeTableModel.setClockType(this.getCurrentRenderClock());
        this.myTreeTable.setModel((TreeTableModel)this.myVmStatsTreeTableModel);
        VmStatsTreeUtils.adjustTableColumnWidths(this.myTreeTable);
        VmStatsTreeUtils.setCellRenderers(this.myTreeTable);
        VmStatsTreeUtils.setSpeedSearch(this.myTreeTable);
        VmStatsTreeUtils.enableSorting(this.myTreeTable, this.myVmStatsTreeTableModel);
    }

    private ClockType getCurrentRenderClock() {
        return ourRenderClockTypes[this.myRenderClockSelectorCombo.getSelectedIndex()];
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myContainer;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/vmtrace/TraceViewPanel", "getComponent"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        MouseAdapter l = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getSource() == TraceViewPanel.this.myCloseLabel) {
                    TraceViewPanel.this.closeSearchComponent();
                } else if (e.getSource() == TraceViewPanel.this.mySearchLabel) {
                    TraceViewPanel.this.showSearchComponent();
                } else if (e.getSource() == TraceViewPanel.this.myZoomFitLabel) {
                    TraceViewPanel.this.myTraceViewCanvas.zoomFit();
                }
            }
        };
        this.myDefaultHeaderPanel = new EditorHeaderComponent();
        this.mySearchLabel = new JLabel(AllIcons.Actions.Search);
        this.mySearchLabel.addMouseListener(l);
        this.mySearchLabel.setToolTipText("Find (Ctrl + F)");
        this.myZoomFitLabel = new JLabel(AndroidIcons.ZoomFit);
        this.myZoomFitLabel.setToolTipText("Zoom Fit");
        this.myZoomFitLabel.addMouseListener(l);
        this.myFindPanel = new EditorHeaderComponent();
        this.myFindFieldWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.mySearchField = this.createSearchField();
        this.myFindFieldWrapper.add((Component)this.mySearchField);
        this.myCloseLabel = new JLabel(AllIcons.Actions.Cross);
        this.myCloseLabel.addMouseListener(l);
        this.myVmStatsTreeTableModel = new VmStatsTreeTableModel();
        this.myTreeTable = new TreeTable((TreeTableModel)this.myVmStatsTreeTableModel);
        this.myTraceViewCanvas = new TraceViewCanvasWrapper();
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable);
        this.mySplitter = new JBSplitter(true, 0.75f);
        this.mySplitter.setShowDividerControls(true);
        this.mySplitter.setShowDividerIcon(true);
        this.mySplitter.setFirstComponent((JComponent)this.myTraceViewCanvas);
        this.mySplitter.setSecondComponent((JComponent)scrollPane);
    }

    public void showSearchComponent() {
        CardLayout layout = (CardLayout)this.myHeaderPanel.getLayout();
        layout.show(this.myHeaderPanel, CARD_FIND);
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchField, true);
    }

    private void closeSearchComponent() {
        CardLayout layout = (CardLayout)this.myHeaderPanel.getLayout();
        layout.show(this.myHeaderPanel, CARD_DEFAULT);
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTraceViewCanvas, true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContainer = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myHeaderPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
        JPanel jPanel3 = this.myDefaultHeaderPanel;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 8, new Insets(0, 5, 0, 5), -1, -1, false, false));
        jPanel.add((Component)jPanel3, CARD_DEFAULT);
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Thread: ");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myThreadCombo = jComboBox2 = new JComboBox();
        ((Component)jComboBox2).setEnabled(false);
        jPanel3.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("x-axis: ");
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myRenderClockSelectorCombo = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(false);
        jPanel3.add(jComboBox, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), null, null));
        JLabel jLabel = this.mySearchLabel;
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/intellij/ide/ui/laf/darcula/icons/search.png")));
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 7, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = this.myZoomFitLabel;
        jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/icons/zoomFit.png")));
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 6, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseInclusiveTimeForColoring = jCheckBox = new JCheckBox();
        jCheckBox.setText("Color by inclusive time");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = this.myFindPanel;
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 5, 0, 5), -1, -1, false, false));
        jPanel.add((Component)jPanel4, CARD_FIND);
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Find:");
        jPanel4.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel3 = this.myCloseLabel;
        jLabel3.setText("");
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = this.myFindFieldWrapper;
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, new Dimension(300, -1), null, null));
        this.myResultsLabel = jBLabel = new JBLabel();
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JBSplitter jBSplitter = this.mySplitter;
        jBSplitter.setOrientation(true);
        jBSplitter.setShowDividerControls(true);
        jPanel2.add((Component)jBSplitter, "Center");
        jBLabel2.setLabelFor(jComboBox2);
        jBLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    private class TraceViewCanvasWrapper
    extends TraceViewCanvas
    implements DataProvider {
        public TraceViewCanvasWrapper() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    IdeFocusManager.getInstance((Project)TraceViewPanel.this.myProject).requestFocus((Component)((Object)TraceViewCanvasWrapper.this), true);
                }
            });
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return KEY.is(dataId) ? TraceViewPanel.this : null;
        }
    }
}

