/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModelView {
    private static final ImmutableMultimap<String, String> SOURCE_PROVIDERS_GROUP = ImmutableMultimap.builder().putAll((Object)"SourceProviders", (Object[])new String[]{"SourceProvider", "ExtraSourceProviders"}).build();
    private static final ImmutableMultimap<String, String> SDK_VERSIONS_GROUP = ImmutableMultimap.builder().putAll((Object)"SdkVersions", (Object[])new String[]{"MinSdkVersion", "MaxSdkVersion", "TargetSdkVersion"}).build();
    private static final ImmutableMultimap<String, String> ARTIFACTS_GROUP = ImmutableMultimap.builder().putAll((Object)"Artifacts", (Object[])new String[]{"MainArtifact", "ExtraAndroidArtifacts", "ExtraJavaArtifacts"}).build();
    private static final ImmutableMultimap<String, String> JNI_DIRECTORIES_GROUP = ImmutableMultimap.builder().putAll((Object)"JniDirectories", (Object[])new String[]{"CDirectories"}).build();
    @NotNull
    private final Project myProject;
    @NotNull
    private final Tree myTree;

    public AndroidModelView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidModelView", "<init>"));
        }
        this.myProject = project;
        this.myTree = new Tree();
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncStarted(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidModelView$1", "syncStarted"));
                }
                AndroidModelView.this.updateContents();
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidModelView$1", "syncSucceeded"));
                }
                AndroidModelView.this.updateContents();
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidModelView$1", "syncFailed"));
                }
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/AndroidModelView$1", "syncFailed"));
                }
                AndroidModelView.this.updateContents();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidModelView$1", "syncSkipped"));
                }
                AndroidModelView.this.updateContents();
            }
        });
    }

    public static AndroidModelView getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidModelView", "getInstance"));
        }
        return (AndroidModelView)ServiceManager.getService((Project)project, AndroidModelView.class);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/idea/gradle/AndroidModelView", "createToolWindowContent"));
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ToolWindowAlikePanel toolWindowPanel = ToolWindowAlikePanel.createTreePanel(this.myProject.getName(), (JTree)this.myTree);
        Content content = contentFactory.createContent((JComponent)toolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    private void updateContents() {
        this.myTree.setRootVisible(true);
        if (GradleSyncState.getInstance(this.myProject).isSyncInProgress()) {
            this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Gradle project sync in progress ...")));
            return;
        }
        this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Loading ...")));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.myProject.getName());
            String projectPath = this.myProject.getBasePath();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel == null) continue;
                DefaultMutableTreeNode moduleNode = new ModuleNodeBuilder(module.getName(), androidModel, projectPath).getNode();
                rootNode.add(moduleNode);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setOpenIcon(AllIcons.Nodes.NewFolder);
                renderer.setClosedIcon(AllIcons.Nodes.NewFolder);
                renderer.setLeafIcon(AllIcons.ObjectBrowser.ShowModules);
                this.myTree.setCellRenderer((TreeCellRenderer)renderer);
                DefaultTreeModel model = new DefaultTreeModel(rootNode);
                this.myTree.setRootVisible(false);
                this.myTree.setModel((TreeModel)model);
            });
        });
    }

    static class ModuleNodeBuilder {
        @NotNull
        private final String myModuleName;
        @NotNull
        private final AndroidModuleModel myAndroidModel;
        @Nullable
        private final String myProjectPath;
        private List<DefaultMutableTreeNode> artifactNodes;

        public ModuleNodeBuilder(@NotNull String moduleName, @NotNull AndroidModuleModel androidModel, @Nullable String projectPath) {
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "<init>"));
            }
            if (androidModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "<init>"));
            }
            this.artifactNodes = Lists.newArrayList();
            this.myModuleName = moduleName;
            this.myAndroidModel = androidModel;
            if (projectPath != null && !projectPath.endsWith(File.separator)) {
                projectPath = projectPath + File.separator;
            }
            this.myProjectPath = projectPath == null ? null : FileUtil.toSystemDependentName((String)projectPath);
        }

        public DefaultMutableTreeNode getNode() {
            DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(this.myModuleName);
            AndroidProject androidProject = this.myAndroidModel.waitForAndGetProxyAndroidProject();
            this.artifactNodes.clear();
            this.addProxyObject(moduleNode, androidProject, false, (Collection<String>)ImmutableList.of((Object)"SyncIssues", (Object)"UnresolvedDependencies", (Object)"ApiVersion"));
            this.artifactNodes.forEach(this::addSources);
            return moduleNode;
        }

        void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            this.addProxyObject(node, obj, false);
        }

        private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            this.addProxyObject(node, obj, useDerivedNodeName, (Collection<String>)ImmutableList.of());
        }

        private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName, @NotNull Collection<String> skipProperties) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (skipProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipProperties", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            this.addProxyObject(node, obj, useDerivedNodeName, skipProperties, (Collection<String>)ImmutableList.of(), (Multimap<String, String>)ImmutableMultimap.of());
        }

        private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName, @NotNull Collection<String> inlineProperties, @NotNull Multimap<String, String> groupProperties) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (inlineProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineProperties", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (groupProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupProperties", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            this.addProxyObject(node, obj, useDerivedNodeName, (Collection<String>)ImmutableList.of(), inlineProperties, groupProperties);
        }

        private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName, @NotNull Collection<String> skipProperties, @NotNull Collection<String> inlineProperties, @NotNull Multimap<String, String> groupProperties) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (skipProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipProperties", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (inlineProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineProperties", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            if (groupProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupProperties", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addProxyObject"));
            }
            assert (ProxyUtil.isAndroidModelProxyObject(obj));
            HashMap groupPropertyNodes = Maps.newHashMap();
            String name = null;
            for (Map.Entry<String, Object> entry : ProxyUtil.getAndroidModelProxyValues(obj).entrySet()) {
                String property = entry.getKey();
                property = property.substring(0, property.lastIndexOf(40));
                property = property.substring(property.lastIndexOf(46) + 1, property.length());
                if (skipProperties.contains(property = StringUtil.trimStart((String)property, (String)"get"))) continue;
                boolean useDerivedNameValue = false;
                boolean addToParentNode = false;
                Object value = entry.getValue();
                if (value != null && property.equals("Name")) {
                    name = value.toString();
                }
                if (inlineProperties.contains(property)) {
                    addToParentNode = true;
                    useDerivedNameValue = useDerivedNodeName;
                }
                DefaultMutableTreeNode parentNode = node;
                if (groupProperties.values().contains(property)) {
                    for (Map.Entry group : groupProperties.entries()) {
                        if (!((String)group.getValue()).equals(property)) continue;
                        String groupName = (String)group.getKey();
                        DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)groupPropertyNodes.get(groupName);
                        if (groupNode == null) {
                            groupNode = new DefaultMutableTreeNode(groupName);
                            groupPropertyNodes.put(groupName, groupNode);
                        }
                        parentNode = groupNode;
                        useDerivedNameValue = true;
                        break;
                    }
                }
                this.addPropertyNode(parentNode, property, value, useDerivedNameValue, addToParentNode);
            }
            for (DefaultMutableTreeNode groupNode : groupPropertyNodes.values()) {
                ModuleNodeBuilder.addToNode(node, groupNode);
            }
            if (useDerivedNodeName && name != null) {
                node.setUserObject(name);
            }
        }

        private void addPropertyNode(@NotNull DefaultMutableTreeNode node, @NotNull String property, @Nullable Object value, boolean useDerivedNodeName, boolean addToParentNode) {
            DefaultMutableTreeNode propertyNode;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addPropertyNode"));
            }
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addPropertyNode"));
            }
            DefaultMutableTreeNode defaultMutableTreeNode = propertyNode = addToParentNode ? node : new DefaultMutableTreeNode(property);
            if (value != null && ProxyUtil.isAndroidModelProxyObject(value)) {
                if (!this.customizeProxyObject(propertyNode, value, useDerivedNodeName)) {
                    this.addProxyObject(propertyNode, value, useDerivedNodeName);
                }
            } else if (value instanceof Collection && (!((Collection)value).isEmpty() || addToParentNode)) {
                for (Object obj : (Collection)value) {
                    this.addPropertyNode(propertyNode, "", obj, true, false);
                }
            } else if (value instanceof Map && (!((Map)value).isEmpty() || addToParentNode)) {
                Map map = (Map)value;
                for (Object key : map.keySet()) {
                    this.addPropertyNode(propertyNode, key.toString(), map.get(key), false, false);
                }
            } else if (value instanceof ProxyUtil.InvocationErrorValue) {
                Throwable exception = ((ProxyUtil.InvocationErrorValue)value).exception;
                propertyNode.setUserObject(ModuleNodeBuilder.getNodeValue(property, "Error: " + exception.getClass().getName()));
            } else {
                propertyNode.setUserObject(ModuleNodeBuilder.getNodeValue(property, this.getStringForValue(value)));
            }
            if (!addToParentNode) {
                ModuleNodeBuilder.addToNode(node, propertyNode);
            }
        }

        private boolean customizeProxyObject(@NotNull DefaultMutableTreeNode propertyNode, @NotNull Object value, boolean useDerivedName) {
            if (propertyNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyNode", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "customizeProxyObject"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "customizeProxyObject"));
            }
            assert (ProxyUtil.isAndroidModelProxyObject(value));
            if (value instanceof ProductFlavorContainer) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of((Object)"ProductFlavor", (Object)"ExtraSourceProviders"), (Multimap<String, String>)SOURCE_PROVIDERS_GROUP);
            } else if (value instanceof BuildTypeContainer) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of((Object)"BuildType", (Object)"ExtraSourceProviders"), (Multimap<String, String>)SOURCE_PROVIDERS_GROUP);
            } else if (value instanceof SourceProviderContainer) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of((Object)"SourceProvider"), (Multimap<String, String>)ImmutableMultimap.of());
            } else if (value instanceof SourceProvider) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of((Object)"CppDirectories"), (Collection<String>)ImmutableList.of((Object)"CDirectories"), (Multimap<String, String>)JNI_DIRECTORIES_GROUP);
            } else if (value instanceof ProductFlavor) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of(), (Multimap<String, String>)SDK_VERSIONS_GROUP);
            } else if (value instanceof Variant) {
                this.addProxyObject(propertyNode, value, useDerivedName, (Collection<String>)ImmutableList.of(), (Collection<String>)ImmutableList.of((Object)"ExtraAndroidArtifacts", (Object)"ExtraJavaArtifacts"), (Multimap<String, String>)ARTIFACTS_GROUP);
            } else if (value instanceof BaseArtifact) {
                this.addProxyObject(propertyNode, value, useDerivedName);
                this.artifactNodes.add(propertyNode);
            } else {
                return false;
            }
            return true;
        }

        private void addSources(@NotNull DefaultMutableTreeNode artifactNode) {
            if (artifactNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactNode", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addSources"));
            }
            String artifactName = artifactNode.getUserObject().toString();
            String variantName = ((DefaultMutableTreeNode)artifactNode.getParent().getParent()).getUserObject().toString();
            List<SourceProvider> sourceProviders = artifactName.equals("_main_") ? this.myAndroidModel.getMainSourceProviders(variantName) : this.myAndroidModel.getTestSourceProviders(variantName, artifactName);
            DefaultMutableTreeNode sourcesNode = new DefaultMutableTreeNode("Sources");
            this.addSourceProviders(sourcesNode, sourceProviders);
            ModuleNodeBuilder.addToNode(artifactNode, sourcesNode);
        }

        private void addSourceProviders(@NotNull DefaultMutableTreeNode sourcesNode, @NotNull List<SourceProvider> sourceProviders) {
            if (sourcesNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcesNode", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addSourceProviders"));
            }
            if (sourceProviders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProviders", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addSourceProviders"));
            }
            DefaultMutableTreeNode manifestFilesNode = new DefaultMutableTreeNode("ManifestFiles");
            DefaultMutableTreeNode javaDirectoriesNode = new DefaultMutableTreeNode("JavaDirectories");
            DefaultMutableTreeNode jniDirectoriesNode = new DefaultMutableTreeNode("JniDirectories");
            DefaultMutableTreeNode jniLibsDirectoriesNode = new DefaultMutableTreeNode("JniLibsDirectories");
            DefaultMutableTreeNode resDirectoriesNode = new DefaultMutableTreeNode("ResDirectories");
            DefaultMutableTreeNode aidlDirectoriesNode = new DefaultMutableTreeNode("AidlDirectories");
            DefaultMutableTreeNode resourcesDirectoriesNode = new DefaultMutableTreeNode("ResourcesDirectories");
            DefaultMutableTreeNode assetsDirectoriesNode = new DefaultMutableTreeNode("AssetsDirectories");
            DefaultMutableTreeNode renderscriptDirectoriesNode = new DefaultMutableTreeNode("RenderscriptDirectories");
            for (SourceProvider sourceProvider : sourceProviders) {
                this.addFiles(manifestFilesNode, (Collection<File>)ImmutableList.of((Object)sourceProvider.getManifestFile()));
                this.addFiles(javaDirectoriesNode, sourceProvider.getJavaDirectories());
                this.addFiles(jniDirectoriesNode, sourceProvider.getCDirectories());
                this.addFiles(jniLibsDirectoriesNode, sourceProvider.getJniLibsDirectories());
                this.addFiles(resDirectoriesNode, sourceProvider.getResDirectories());
                this.addFiles(aidlDirectoriesNode, sourceProvider.getAidlDirectories());
                this.addFiles(resourcesDirectoriesNode, sourceProvider.getResourcesDirectories());
                this.addFiles(assetsDirectoriesNode, sourceProvider.getAssetsDirectories());
                this.addFiles(renderscriptDirectoriesNode, sourceProvider.getRenderscriptDirectories());
            }
            sourcesNode.add(manifestFilesNode);
            sourcesNode.add(javaDirectoriesNode);
            sourcesNode.add(jniDirectoriesNode);
            sourcesNode.add(jniLibsDirectoriesNode);
            sourcesNode.add(resDirectoriesNode);
            sourcesNode.add(aidlDirectoriesNode);
            sourcesNode.add(resourcesDirectoriesNode);
            sourcesNode.add(assetsDirectoriesNode);
            sourcesNode.add(renderscriptDirectoriesNode);
        }

        private void addFiles(@NotNull DefaultMutableTreeNode node, Collection<File> files) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addFiles"));
            }
            for (File file : files) {
                node.add(new DefaultMutableTreeNode(this.getStringForValue(file)));
            }
        }

        @NotNull
        private String getStringForValue(@Nullable Object value) {
            if (value != null && value instanceof File) {
                String filePath = ((File)value).getPath();
                if (this.myProjectPath != null && filePath.startsWith(this.myProjectPath)) {
                    String string = filePath.substring(this.myProjectPath.length());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "getStringForValue"));
                    }
                    return string;
                }
            }
            String string = value == null ? "null" : value.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "getStringForValue"));
            }
            return string;
        }

        @NotNull
        private static String getNodeValue(@NotNull String property, @NotNull String value) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "getNodeValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "getNodeValue"));
            }
            String string = property.isEmpty() ? value : property + " -> " + value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "getNodeValue"));
            }
            return string;
        }

        private static void addToNode(@NotNull DefaultMutableTreeNode parent, @NotNull DefaultMutableTreeNode newChild) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addToNode"));
            }
            if (newChild == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "addToNode"));
            }
            for (int i = 0; i < parent.getChildCount(); ++i) {
                DefaultMutableTreeNode existingChild = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (ModuleNodeBuilder.compareTo(existingChild, newChild) < 0) continue;
                parent.insert(newChild, i);
                return;
            }
            parent.add(newChild);
        }

        private static int compareTo(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2) {
            if (node1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node1", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "compareTo"));
            }
            if (node2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node2", "com/android/tools/idea/gradle/AndroidModelView$ModuleNodeBuilder", "compareTo"));
            }
            if (node1.isLeaf() && !node2.isLeaf()) {
                return -1;
            }
            if (!node1.isLeaf() && node2.isLeaf()) {
                return 1;
            }
            return node1.getUserObject().toString().compareTo(node2.getUserObject().toString());
        }
    }
}

