/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class SyncProjectAction
extends AndroidStudioGradleAction {
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;

    public SyncProjectAction() {
        this("Sync Project with Gradle Files");
    }

    protected SyncProjectAction(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/actions/SyncProjectAction", "<init>"));
        }
        this(text, GradleSyncInvoker.getInstance());
    }

    @VisibleForTesting
    SyncProjectAction(@NotNull String text, @NotNull GradleSyncInvoker syncInvoker) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/actions/SyncProjectAction", "<init>"));
        }
        if (syncInvoker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncInvoker", "com/android/tools/idea/gradle/actions/SyncProjectAction", "<init>"));
        }
        super(text);
        this.mySyncInvoker = syncInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/SyncProjectAction", "doPerform"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/SyncProjectAction", "doPerform"));
        }
        BuildVariantView.getInstance(project).projectImportStarted();
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        try {
            this.mySyncInvoker.requestProjectSyncAndSourceGeneration(project, null);
        }
        finally {
            presentation.setEnabled(true);
        }
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/SyncProjectAction", "doUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/SyncProjectAction", "doUpdate"));
        }
        boolean enabled = !GradleSyncState.getInstance(project).isSyncInProgress();
        e.getPresentation().setEnabled(enabled);
    }
}

