/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android.sourceSets;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.android.sourceSets.SourceDirectoryDslElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceDirectoryModel
extends GradleDslBlockModel {
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String SRC_DIRS = "srcDirs";

    public SourceDirectoryModel(@NotNull SourceDirectoryDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "<init>"));
        }
        super(dslElement);
    }

    @NotNull
    public String name() {
        String string = this.myDslElement.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "name"));
        }
        return string;
    }

    @Nullable
    public List<GradleNotNullValue<String>> excludes() {
        return this.myDslElement.getListProperty(EXCLUDE, String.class);
    }

    @NotNull
    public SourceDirectoryModel addExclude(@NotNull String exclude) {
        if (exclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EXCLUDE, "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "addExclude"));
        }
        this.myDslElement.addToNewLiteralList(EXCLUDE, exclude);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "addExclude"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel removeExclude(@NotNull String exclude) {
        if (exclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EXCLUDE, "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeExclude"));
        }
        this.myDslElement.removeFromExpressionList(EXCLUDE, exclude);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeExclude"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel removeAllExcludes() {
        this.myDslElement.removeProperty(EXCLUDE);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeAllExcludes"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel replaceExclude(@NotNull String oldExclude, @NotNull String newExclude) {
        if (oldExclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldExclude", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceExclude"));
        }
        if (newExclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExclude", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceExclude"));
        }
        this.myDslElement.replaceInExpressionList(EXCLUDE, oldExclude, newExclude);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceExclude"));
        }
        return sourceDirectoryModel;
    }

    @Nullable
    public List<GradleNotNullValue<String>> includes() {
        return this.myDslElement.getListProperty(INCLUDE, String.class);
    }

    @NotNull
    public SourceDirectoryModel addInclude(@NotNull String include) {
        if (include == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", INCLUDE, "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "addInclude"));
        }
        this.myDslElement.addToNewLiteralList(INCLUDE, include);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "addInclude"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel removeInclude(@NotNull String include) {
        if (include == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", INCLUDE, "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeInclude"));
        }
        this.myDslElement.removeFromExpressionList(INCLUDE, include);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeInclude"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel removeAllIncludes() {
        this.myDslElement.removeProperty(INCLUDE);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeAllIncludes"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel replaceInclude(@NotNull String oldInclude, @NotNull String newInclude) {
        if (oldInclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInclude", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceInclude"));
        }
        if (newInclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newInclude", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceInclude"));
        }
        this.myDslElement.replaceInExpressionList(INCLUDE, oldInclude, newInclude);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceInclude"));
        }
        return sourceDirectoryModel;
    }

    @Nullable
    public List<GradleNotNullValue<String>> srcDirs() {
        return this.myDslElement.getListProperty(SRC_DIRS, String.class);
    }

    @NotNull
    public SourceDirectoryModel addSrcDir(@NotNull String srcDir) {
        if (srcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcDir", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "addSrcDir"));
        }
        this.myDslElement.addToNewLiteralList(SRC_DIRS, srcDir);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "addSrcDir"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel removeSrcDir(@NotNull String srcDir) {
        if (srcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcDir", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeSrcDir"));
        }
        this.myDslElement.removeFromExpressionList(SRC_DIRS, srcDir);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeSrcDir"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel removeAllSrcDirs() {
        this.myDslElement.removeProperty(SRC_DIRS);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "removeAllSrcDirs"));
        }
        return sourceDirectoryModel;
    }

    @NotNull
    public SourceDirectoryModel replaceSrcDir(@NotNull String oldSrcDir, @NotNull String newSrcDir) {
        if (oldSrcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldSrcDir", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceSrcDir"));
        }
        if (newSrcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSrcDir", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceSrcDir"));
        }
        this.myDslElement.replaceInExpressionList(SRC_DIRS, oldSrcDir, newSrcDir);
        SourceDirectoryModel sourceDirectoryModel = this;
        if (sourceDirectoryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/sourceSets/SourceDirectoryModel", "replaceSrcDir"));
        }
        return sourceDirectoryModel;
    }
}

