/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleValue;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidPluginGeneration {
    public static final AndroidPluginGeneration ORIGINAL = new AndroidPluginGeneration(){

        @Override
        @NotNull
        public String getArtifactId() {
            if ("gradle" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$1", "getArtifactId"));
            }
            return "gradle";
        }

        @Override
        @NotNull
        protected String getApplicationPluginId() {
            if ("com.android.application" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$1", "getApplicationPluginId"));
            }
            return "com.android.application";
        }

        @Override
        @NotNull
        protected String getLibraryPluginId() {
            if ("com.android.library" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$1", "getLibraryPluginId"));
            }
            return "com.android.library";
        }

        @Override
        @NotNull
        public String getLatestKnownVersion() {
            String string = this.getLatestKnownVersion(this);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$1", "getLatestKnownVersion"));
            }
            return string;
        }

        @Override
        @NotNull
        protected String getRecommendedVersion() {
            if ("2.3.0" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$1", "getRecommendedVersion"));
            }
            return "2.3.0";
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("Android Gradle plugin" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$1", "getDescription"));
            }
            return "Android Gradle plugin";
        }
    };
    public static final AndroidPluginGeneration COMPONENT = new AndroidPluginGeneration(){

        @Override
        @NotNull
        public String getArtifactId() {
            if ("gradle-experimental" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$2", "getArtifactId"));
            }
            return "gradle-experimental";
        }

        @Override
        @NotNull
        protected String getApplicationPluginId() {
            if ("com.android.model.application" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$2", "getApplicationPluginId"));
            }
            return "com.android.model.application";
        }

        @Override
        @NotNull
        protected String getLibraryPluginId() {
            if ("com.android.model.library" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$2", "getLibraryPluginId"));
            }
            return "com.android.model.library";
        }

        @Override
        @NotNull
        public String getLatestKnownVersion() {
            String string = this.getLatestKnownVersion(this);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$2", "getLatestKnownVersion"));
            }
            return string;
        }

        @Override
        @NotNull
        protected String getRecommendedVersion() {
            if ("0.8.0" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$2", "getRecommendedVersion"));
            }
            return "0.8.0";
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("Android Gradle \"experimental\" plugin" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$2", "getDescription"));
            }
            return "Android Gradle \"experimental\" plugin";
        }
    };
    private static AndroidPluginGeneration[] ourValues = new AndroidPluginGeneration[]{ORIGINAL, COMPONENT};

    public boolean isApplicationPluginIdIn(@NotNull Collection<String> pluginIds) {
        if (pluginIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginIds", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "isApplicationPluginIdIn"));
        }
        return pluginIds.contains(this.getApplicationPluginId());
    }

    @NotNull
    protected abstract String getApplicationPluginId();

    protected abstract String getLibraryPluginId();

    public boolean isAndroidPlugin(@NotNull String artifactId, String groupId) {
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "isAndroidPlugin"));
        }
        return this.getArtifactId().equals(artifactId) && AndroidPluginGeneration.getGroupId().equals(groupId);
    }

    @NotNull
    public abstract String getArtifactId();

    public static AndroidPluginGeneration find(@NotNull String artifactId, String groupId) {
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "find"));
        }
        for (AndroidPluginGeneration generation : ourValues) {
            if (!generation.isAndroidPlugin(artifactId, groupId)) continue;
            return generation;
        }
        return null;
    }

    @NotNull
    public static String getGroupId() {
        if ("com.android.tools.build" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "getGroupId"));
        }
        return "com.android.tools.build";
    }

    @NotNull
    public static AndroidPluginGeneration[] values() {
        if (ourValues == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "values"));
        }
        return ourValues;
    }

    public static AndroidPluginGeneration find(@NotNull Module module) {
        GradleBuildModel buildModel;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "find"));
        }
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        if (gradleModel != null) {
            try {
                return gradleModel.getAndroidProject().getPluginGeneration() == 2 ? COMPONENT : ORIGINAL;
            }
            catch (UnsupportedMethodException unsupportedMethodException) {
                // empty catch block
            }
        }
        if ((buildModel = GradleBuildModel.get(module)) != null) {
            List<String> appliedPlugins = GradleValue.getValues(buildModel.appliedPlugins());
            for (AndroidPluginGeneration generation : ourValues) {
                if (!appliedPlugins.contains(generation.getApplicationPluginId()) && !appliedPlugins.contains(generation.getLibraryPluginId())) continue;
                return generation;
            }
        }
        return null;
    }

    @NotNull
    public abstract String getLatestKnownVersion();

    @NotNull
    protected String getLatestKnownVersion(@NotNull AndroidPluginGeneration generation) {
        if (generation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generation", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "getLatestKnownVersion"));
        }
        String artifactId = generation.getArtifactId();
        FileOp fileOp = FileOpUtils.create();
        List<File> repoPaths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
        Optional<GradleCoordinate> highestValueCoordinate = repoPaths.stream().map(repoPath -> MavenRepositories.getHighestInstalledVersion((String)AndroidPluginGeneration.getGroupId(), (String)artifactId, (File)repoPath, null, (boolean)true, (FileOp)fileOp)).filter(coordinate -> coordinate != null).max(GradleCoordinate.COMPARE_PLUS_HIGHER);
        if (!highestValueCoordinate.isPresent()) {
            if (IdeInfo.getInstance().isAndroidStudio() && !AndroidPlugin.isGuiTestingMode() && !ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException("Gradle plugin missing from the offline Maven repo");
            }
            String version = generation.getRecommendedVersion();
            this.getLog().info("'" + artifactId + "' plugin missing from the offline Maven repo, will use default " + version);
            String string = version;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "getLatestKnownVersion"));
            }
            return string;
        }
        String string = highestValueCoordinate.get().getRevision();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "getLatestKnownVersion"));
        }
        return string;
    }

    @NotNull
    protected abstract String getRecommendedVersion();

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration", "getLog"));
        }
        return logger;
    }

    @NotNull
    public abstract String getDescription();
}

