/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.cleanup;

import com.android.tools.idea.gradle.project.sync.cleanup.BuildOutputViewCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.GradleDistributionCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.GradleRunnerCleanupTask;
import com.android.tools.idea.gradle.project.sync.cleanup.GradleSettingsCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.HttpProxySettingsCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.ProjectCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.ProjectPreferencesCleanUpTask;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class PreSyncProjectCleanUp {
    @NotNull
    private final ProjectCleanUpTask[] myCleanUpTasks;

    @NotNull
    public static PreSyncProjectCleanUp getInstance() {
        PreSyncProjectCleanUp preSyncProjectCleanUp = (PreSyncProjectCleanUp)ServiceManager.getService(PreSyncProjectCleanUp.class);
        if (preSyncProjectCleanUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/cleanup/PreSyncProjectCleanUp", "getInstance"));
        }
        return preSyncProjectCleanUp;
    }

    public PreSyncProjectCleanUp() {
        this(new ProjectPreferencesCleanUpTask(), new GradleRunnerCleanupTask(), new HttpProxySettingsCleanUpTask(), new GradleSettingsCleanUpTask(), new GradleDistributionCleanUpTask(), new BuildOutputViewCleanUpTask());
    }

    @VisibleForTesting
    PreSyncProjectCleanUp(ProjectCleanUpTask ... cleanUpTasks) {
        if (cleanUpTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cleanUpTasks", "com/android/tools/idea/gradle/project/sync/cleanup/PreSyncProjectCleanUp", "<init>"));
        }
        this.myCleanUpTasks = cleanUpTasks;
    }

    public void cleanUp(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/cleanup/PreSyncProjectCleanUp", "cleanUp"));
        }
        for (ProjectCleanUpTask task : this.myCleanUpTasks) {
            task.cleanUp(project);
        }
    }

    @VisibleForTesting
    @NotNull
    ProjectCleanUpTask[] getCleanUpTasks() {
        if (this.myCleanUpTasks == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/cleanup/PreSyncProjectCleanUp", "getCleanUpTasks"));
        }
        return this.myCleanUpTasks;
    }
}

