/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InstallPlatformHyperlink
extends NotificationHyperlink {
    @NotNull
    private final AndroidVersion[] myAndroidVersions;

    public InstallPlatformHyperlink(@NotNull Collection<AndroidVersion> androidVersions) {
        if (androidVersions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidVersions", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallPlatformHyperlink", "<init>"));
        }
        this(androidVersions.toArray(new AndroidVersion[androidVersions.size()]));
    }

    public InstallPlatformHyperlink(AndroidVersion ... androidVersions) {
        if (androidVersions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidVersions", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallPlatformHyperlink", "<init>"));
        }
        super("install.android.platform", "Install missing platform(s) and sync project");
        this.myAndroidVersions = androidVersions;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallPlatformHyperlink", "execute"));
        }
        ArrayList requested = Lists.newArrayList();
        for (AndroidVersion version : this.myAndroidVersions) {
            requested.add(DetailsTypes.getPlatformPath((AndroidVersion)version));
        }
        ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog != null && dialog.showAndGet()) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
        }
    }
}

