/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;

class ExternalNdkBuildIssuesReporter
extends BaseSyncIssuesReporter {
    @NotNull
    private final BuildOutputParser myBuildOutputParser;
    @NotNull
    private final SyncErrorHandler[] myErrorHandlers;

    ExternalNdkBuildIssuesReporter() {
        this(ExternalNdkBuildIssuesReporter.createBuildOutputParser(), SyncErrorHandler.getExtensions());
    }

    @NotNull
    private static BuildOutputParser createBuildOutputParser() {
        BuildOutputParser buildOutputParser = new BuildOutputParser(JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class));
        if (buildOutputParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/ExternalNdkBuildIssuesReporter", "createBuildOutputParser"));
        }
        return buildOutputParser;
    }

    @VisibleForTesting
    ExternalNdkBuildIssuesReporter(@NotNull BuildOutputParser buildOutputParser, @NotNull SyncErrorHandler[] errorHandlers) {
        if (buildOutputParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildOutputParser", "com/android/tools/idea/gradle/project/sync/issues/ExternalNdkBuildIssuesReporter", "<init>"));
        }
        if (errorHandlers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandlers", "com/android/tools/idea/gradle/project/sync/issues/ExternalNdkBuildIssuesReporter", "<init>"));
        }
        this.myBuildOutputParser = buildOutputParser;
        this.myErrorHandlers = errorHandlers;
    }

    @Override
    int getSupportedIssueType() {
        return 17;
    }

    @Override
    void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        if (syncIssue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssue", "com/android/tools/idea/gradle/project/sync/issues/ExternalNdkBuildIssuesReporter", "report"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/issues/ExternalNdkBuildIssuesReporter", "report"));
        }
        String group = "External Native Build Issues";
        String nativeToolOutput = syncIssue.getData();
        if (nativeToolOutput != null) {
            SyncMessages messages = this.getSyncMessages(module);
            List compilerMessages = this.myBuildOutputParser.parseGradleOutput(nativeToolOutput);
            for (Message compilerMessage : compilerMessages) {
                MessageType type = MessageType.findMatching(compilerMessage.getKind());
                PositionInFile position = ExternalNdkBuildIssuesReporter.createPosition(compilerMessage.getSourceFilePositions());
                String text = compilerMessage.getText();
                Project project = module.getProject();
                if (type == MessageType.ERROR) {
                    NotificationCategory category = type.convertToCategory();
                    NotificationData notification = messages.createNotification(group, text, category, position);
                    for (SyncErrorHandler handler : this.myErrorHandlers) {
                        if (handler.handleError(new ExternalSystemException(text), notification, project)) break;
                    }
                    messages.report(notification);
                    continue;
                }
                SyncMessage message = position != null ? new SyncMessage(project, group, type, position, text) : new SyncMessage(group, type, text);
                messages.report(message);
            }
        }
    }

    @Nullable
    private static PositionInFile createPosition(@NotNull List<SourceFilePosition> sourceFilePositions) {
        if (sourceFilePositions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFilePositions", "com/android/tools/idea/gradle/project/sync/issues/ExternalNdkBuildIssuesReporter", "createPosition"));
        }
        assert (!sourceFilePositions.isEmpty());
        VirtualFile sourceFile = null;
        SourceFile source = sourceFilePositions.get(0).getFile();
        if (source.getSourceFile() != null) {
            sourceFile = VfsUtil.findFileByIoFile((File)source.getSourceFile(), (boolean)true);
        }
        if (sourceFile != null) {
            SourcePosition sourcePosition = sourceFilePositions.get(0).getPosition();
            return new PositionInFile(sourceFile, sourcePosition.getStartLine(), sourcePosition.getStartColumn());
        }
        return null;
    }
}

