/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.java;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetupStep;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelModuleSetupStep
extends JavaModuleSetupStep {
    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaLanguageLevelModuleSetupStep", "doSetUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaLanguageLevelModuleSetupStep", "doSetUpModule"));
        }
        if (javaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModuleModel", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaLanguageLevelModuleSetupStep", "doSetUpModule"));
        }
        LanguageLevel languageLevel = javaModuleModel.getJavaLanguageLevel();
        if (languageLevel == null) {
            languageLevel = JavaLanguageLevelModuleSetupStep.getMinimumLanguageLevelForAndroidModules(ideModelsProvider);
        }
        if (languageLevel == null) {
            languageLevel = LanguageLevel.JDK_1_6;
        }
        ModifiableRootModel rootModel = ideModelsProvider.getModifiableRootModel(module);
        LanguageLevelModuleExtensionImpl moduleExtension = (LanguageLevelModuleExtensionImpl)rootModel.getModuleExtension(LanguageLevelModuleExtensionImpl.class);
        moduleExtension.setLanguageLevel(languageLevel);
    }

    @Nullable
    private static LanguageLevel getMinimumLanguageLevelForAndroidModules(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaLanguageLevelModuleSetupStep", "getMinimumLanguageLevelForAndroidModules"));
        }
        Module[] modules = modelsProvider.getModules();
        if (modules.length == 0) {
            return null;
        }
        LanguageLevel result = null;
        ArrayList<LanguageLevel> languageLevels = new ArrayList<LanguageLevel>();
        for (Module dependency : modules) {
            LanguageLevel dependencyLanguageLevel = JavaLanguageLevelModuleSetupStep.getLanguageLevelForAndroidModule(dependency, modelsProvider);
            if (dependencyLanguageLevel == null) continue;
            languageLevels.add(dependencyLanguageLevel);
        }
        for (LanguageLevel dependencyLanguageLevel : languageLevels) {
            if (result != null && result.compareTo((Enum)dependencyLanguageLevel) <= 0) continue;
            result = dependencyLanguageLevel;
        }
        return result;
    }

    @Nullable
    private static LanguageLevel getLanguageLevelForAndroidModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        AndroidModuleModel androidModel;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaLanguageLevelModuleSetupStep", "getLanguageLevelForAndroidModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaLanguageLevelModuleSetupStep", "getLanguageLevelForAndroidModule"));
        }
        AndroidFacet facet = Facets.findFacet(module, modelsProvider, AndroidFacet.ID);
        if (facet != null && (androidModel = AndroidModuleModel.get(facet)) != null) {
            return androidModel.getJavaLanguageLevel();
        }
        return null;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Java language level setup" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaLanguageLevelModuleSetupStep", "getDescription"));
        }
        return "Java language level setup";
    }
}

