/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.RecommendedPluginVersionUpdateDialog;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class RecommendedPluginVersionUpgradeStep
extends PluginVersionUpgradeStep {
    @Override
    public boolean checkAndPerformUpgrade(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeStep", "checkAndPerformUpgrade"));
        }
        if (pluginInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginInfo", "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeStep", "checkAndPerformUpgrade"));
        }
        if (RecommendedPluginVersionUpgradeStep.shouldRecommendUpgrade(pluginInfo)) {
            GradleVersion latestGradleVersion;
            AndroidPluginVersionUpdater updater;
            AndroidPluginVersionUpdater.UpdateResult result;
            GradleVersion current = pluginInfo.getPluginVersion();
            assert (current != null);
            AndroidPluginGeneration pluginGeneration = pluginInfo.getPluginGeneration();
            GradleVersion recommended = GradleVersion.parse((String)pluginGeneration.getLatestKnownVersion());
            RecommendedPluginVersionUpdateDialog updateDialog = new RecommendedPluginVersionUpdateDialog(project, current, recommended);
            boolean userAcceptsUpgrade = updateDialog.showAndGet();
            if (userAcceptsUpgrade && (result = (updater = AndroidPluginVersionUpdater.getInstance(project)).updatePluginVersionAndSync(recommended, latestGradleVersion = GradleVersion.parse((String)"3.3"), false)).versionUpdateSuccess()) {
                return true;
            }
        }
        return false;
    }

    private static boolean shouldRecommendUpgrade(@NotNull AndroidPluginInfo androidPluginInfo) {
        if (androidPluginInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidPluginInfo", "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeStep", "shouldRecommendUpgrade"));
        }
        return RecommendedPluginVersionUpgradeStep.shouldRecommendUpgradeBasedOnPluginVersion(androidPluginInfo);
    }

    private static boolean shouldRecommendUpgradeBasedOnPluginVersion(@NotNull AndroidPluginInfo androidPluginInfo) {
        if (androidPluginInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidPluginInfo", "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeStep", "shouldRecommendUpgradeBasedOnPluginVersion"));
        }
        GradleVersion current = androidPluginInfo.getPluginVersion();
        String recommended = androidPluginInfo.getPluginGeneration().getLatestKnownVersion();
        return current != null && current.compareTo(recommended) < 0;
    }
}

