/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.fd.InstantRunTasksProvider;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.collect.Lists;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleModuleTasksProvider
implements InstantRunTasksProvider {
    private final Module[] myModules;

    GradleModuleTasksProvider(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "<init>"));
        }
        this.myModules = modules;
        if (this.myModules.length == 0) {
            throw new IllegalArgumentException("No modules provided");
        }
    }

    @Override
    @NotNull
    public List<String> getCleanAndGenerateSourcesTasks() {
        ArrayList tasks = Lists.newArrayList();
        tasks.addAll(GradleBuildInvoker.findCleanTasksForModules(this.myModules));
        tasks.addAll(GradleBuildInvoker.findTasksToExecute(this.myModules, BuildMode.SOURCE_GEN, GradleBuildInvoker.TestCompileType.NONE));
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getCleanAndGenerateSourcesTasks"));
        }
        return arrayList;
    }

    @NotNull
    public List<String> getUnitTestTasks(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getUnitTestTasks"));
        }
        Module[] affectedModules = GradleModuleTasksProvider.getAffectedModules(this.myModules[0].getProject(), this.myModules);
        List<String> list = GradleBuildInvoker.findTasksToExecute(affectedModules, buildMode, GradleBuildInvoker.TestCompileType.UNIT_TESTS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getUnitTestTasks"));
        }
        return list;
    }

    @NotNull
    private static Module[] getAffectedModules(@NotNull Project project, @NotNull Module[] modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getAffectedModules"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getAffectedModules"));
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope scope = compilerManager.createModulesCompileScope(modules, true, true);
        Module[] moduleArray = scope.getAffectedModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getAffectedModules"));
        }
        return moduleArray;
    }

    @Override
    @NotNull
    public List<String> getFullBuildTasks() {
        List<String> list = this.getTasksFor(BuildMode.ASSEMBLE, GradleBuildInvoker.TestCompileType.NONE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getFullBuildTasks"));
        }
        return list;
    }

    @NotNull
    public List<String> getTasksFor(@NotNull BuildMode buildMode, @NotNull GradleBuildInvoker.TestCompileType testCompileType) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getTasksFor"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getTasksFor"));
        }
        List<String> list = GradleBuildInvoker.findTasksToExecute(this.myModules, buildMode, testCompileType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleModuleTasksProvider", "getTasksFor"));
        }
        return list;
    }
}

