/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding;

import com.android.tools.idea.lang.databinding.DbFileType;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.dom.layout.Layout;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingCompletionUtil {
    public static final String JAVA_LANG = "java.lang.";

    public static void addCompletions(@NotNull CompletionParameters params, @NotNull CompletionResultSet resultSet) {
        PsiElement originalParent;
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "addCompletions"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "addCompletions"));
        }
        PsiElement originalPosition = params.getOriginalPosition();
        PsiElement psiElement = originalParent = originalPosition == null ? null : originalPosition.getParent();
        if (originalParent == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalParent);
        if (module == null) {
            return;
        }
        PsiFile containingFile = DataBindingCompletionUtil.getRealContainingFile(originalParent.getContainingFile());
        if (containingFile == null) {
            return;
        }
        String packagePrefix = DataBindingCompletionUtil.getPackagePrefix(originalParent, params.getOffset());
        DataBindingCompletionUtil.fillAliases(resultSet, packagePrefix, originalPosition, module, originalParent);
        DataBindingCompletionUtil.fillClassNames(resultSet, packagePrefix, module);
        JavaClassNameCompletionContributor.addAllClasses((CompletionParameters)params, (boolean)true, (PrefixMatcher)resultSet.getPrefixMatcher(), arg_0 -> ((CompletionResultSet)resultSet).addElement(arg_0));
    }

    private static void fillAliases(@NotNull CompletionResultSet resultSet, @NotNull String packagePrefix, @NotNull PsiElement originalPosition, @NotNull Module module, @NotNull PsiElement originalParent) {
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "fillAliases"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "fillAliases"));
        }
        if (originalPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPosition", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "fillAliases"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "fillAliases"));
        }
        if (originalParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParent", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "fillAliases"));
        }
        PsiFile containingFile = DataBindingCompletionUtil.getRealContainingFile(originalParent.getContainingFile());
        if (containingFile instanceof XmlFile) {
            XmlTag tag;
            Project project = module.getProject();
            DomManager domManager = DomManager.getDomManager((Project)project);
            if (domManager.getDomElement(tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, XmlTag.class, (boolean)false, (Class[])new Class[]{PsiFile.class})) instanceof Import) {
                return;
            }
            DomFileElement file = domManager.getFileElement((XmlFile)containingFile, Layout.class);
            if (file != null) {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                block0: for (Data data : ((Layout)file.getRootElement()).getDatas()) {
                    for (Import anImport : data.getImports()) {
                        String fqcn;
                        PsiClass aClass;
                        String type;
                        String alias = AndroidLayoutUtil.getAlias(anImport);
                        if (packagePrefix.isEmpty()) {
                            String typeValue;
                            PsiClass aClass2;
                            XmlAttributeValue type2 = anImport.getType().getXmlAttributeValue();
                            if (type2 == null || alias == null || (aClass2 = facade.findClass(typeValue = type2.getValue().replace('$', '.'), module.getModuleWithDependenciesAndLibrariesScope(false))) == null) continue;
                            resultSet.addElement((LookupElement)DataBindingCompletionUtil.getClassReferenceElement(alias, aClass2));
                            continue;
                        }
                        int i = packagePrefix.indexOf(46);
                        String possibleAlias = i < 0 ? packagePrefix : packagePrefix.substring(0, i);
                        if (!possibleAlias.equals(alias) || (type = anImport.getType().getStringValue()) == null || (aClass = facade.findClass(fqcn = packagePrefix.equals(alias) ? type : type + packagePrefix.substring(alias.length()), module.getModuleWithDependenciesAndLibrariesScope(false))) == null) continue;
                        for (PsiClass innerClass : aClass.getInnerClasses()) {
                            String name = innerClass.getQualifiedName();
                            if (name == null) continue;
                            resultSet.addElement((LookupElement)DataBindingCompletionUtil.getClassReferenceElement(name.substring(type.length() + 1), innerClass));
                        }
                        continue block0;
                    }
                }
            }
        }
    }

    private static void fillClassNames(@NotNull CompletionResultSet resultSet, @NotNull String packagePrefix, @NotNull Module module) {
        block9: {
            PsiPackage[] subPackages;
            PsiPackage basePackage;
            Project project;
            block8: {
                PsiClass[] innerClasses;
                if (resultSet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "fillClassNames"));
                }
                if (packagePrefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "fillClassNames"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "fillClassNames"));
                }
                project = module.getProject();
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
                basePackage = javaPsiFacade.findPackage(packagePrefix);
                if (basePackage != null) break block8;
                PsiClass aClass = javaPsiFacade.findClass(packagePrefix, module.getModuleWithDependenciesAndLibrariesScope(false));
                if (aClass == null) break block9;
                for (PsiClass psiClass : innerClasses = aClass.getInnerClasses()) {
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(psiClass));
                }
                break block9;
            }
            GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
            for (PsiPackage psiPackage : subPackages = basePackage.getSubPackages(scope)) {
                if (psiPackage.getSubPackages(scope).length <= 0 && psiPackage.getClasses(scope).length <= 0) continue;
                String name = psiPackage.getName();
                boolean invalidPkg = false;
                assert (name != null);
                for (int i = 0; i < name.length(); ++i) {
                    if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                    invalidPkg = true;
                    break;
                }
                if (invalidPkg) continue;
                TailTypeDecorator<LookupElement> element = new TailTypeDecorator<LookupElement>((LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)psiPackage)){

                    @Nullable
                    protected TailType computeTailType(InsertionContext context) {
                        return TailType.DOT;
                    }

                    public void handleInsert(InsertionContext context) {
                        super.handleInsert(context);
                        AutoPopupController.getInstance((Project)project).scheduleAutoPopup(context.getEditor());
                    }
                };
                resultSet.addElement((LookupElement)element);
            }
            for (PsiPackage psiPackage : basePackage.getClasses(scope)) {
                resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement((PsiClass)psiPackage));
            }
        }
    }

    @Contract(value="!null -> !null; null -> null")
    private static PsiFile getRealContainingFile(@Nullable PsiFile file) {
        PsiElement context;
        if (file != null && file.getFileType() == DbFileType.INSTANCE && (context = file.getContext()) != null) {
            file = context.getContainingFile();
        }
        return file;
    }

    @NotNull
    private static JavaPsiClassReferenceElement getClassReferenceElement(String alias, PsiClass referenceClass) {
        JavaPsiClassReferenceElement element = new JavaPsiClassReferenceElement(referenceClass);
        element.setForcedPresentableName(alias);
        element.setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
            }
        });
        JavaPsiClassReferenceElement javaPsiClassReferenceElement = element;
        if (javaPsiClassReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "getClassReferenceElement"));
        }
        return javaPsiClassReferenceElement;
    }

    private static String getPackagePrefix(@NotNull PsiElement context, int offset) {
        char c;
        int i;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lang/databinding/DataBindingCompletionUtil", "getPackagePrefix"));
        }
        CharSequence fileText = context.getContainingFile().getViewProvider().getContents();
        for (i = offset - 1; i >= 0 && (Character.isJavaIdentifierPart(c = fileText.charAt(i)) || c == '.'); --i) {
        }
        String prefix = fileText.subSequence(i + 1, offset).toString();
        int j = prefix.lastIndexOf(46);
        return j > 0 ? prefix.substring(0, j) : "";
    }
}

