/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.GradleDetector;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintNotInterpolatedInspection
extends AndroidLintInspectionBase {
    public AndroidLintNotInterpolatedInspection() {
        super(AndroidBundle.message("android.lint.inspections.not.interpolated", new Object[0]), GradleDetector.NOT_INTERPOLATED);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintNotInterpolatedInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintNotInterpolatedInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintNotInterpolatedInspection", "getQuickFixes"));
        }
        String s = endElement.getText();
        if (s.startsWith("'") && s.endsWith("'") && s.length() > 2) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace single quotes with double quotes", s, "\"" + s.substring(1, s.length() - 1) + "\"")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintNotInterpolatedInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintNotInterpolatedInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

