/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.Range;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.memory.model.MemoryInfoTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class MemoryDetailSegment
extends BaseSegment {
    private static final String SEGMENT_NAME = "Memory Details";
    private static final Color NEGATIVE_COLOR = new JBColor(new Color(0x33FF0000, true), new Color(872375396, true));
    private static final Color POSITIVE_COLOR = new JBColor(new Color(0x330000FF, true), new Color(861445622, true));
    @NotNull
    private final MemoryInfoTreeNode mRoot;
    private JComponent mColumnTree;
    private JTree mTree;
    private DefaultTreeModel mTreeModel;

    public MemoryDetailSegment(@NotNull Range timeCurrentRangeUs, @NotNull MemoryInfoTreeNode root, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "<init>"));
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "<init>"));
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dispatcher);
        this.mRoot = root;
    }

    public void refreshNode(@NotNull MemoryInfoTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "refreshNode"));
        }
        this.mTreeModel.reload(node);
    }

    public boolean getExpandState(@NotNull MemoryInfoTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "getExpandState"));
        }
        return this.mTree.isExpanded(new TreePath(this.mTreeModel.getPathToRoot(node)));
    }

    public void setExpandState(@NotNull MemoryInfoTreeNode node, boolean expand) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "setExpandState"));
        }
        if (expand) {
            this.mTree.expandPath(new TreePath(this.mTreeModel.getPathToRoot(node)));
        } else {
            this.mTree.collapsePath(new TreePath(this.mTreeModel.getPathToRoot(node)));
        }
    }

    public void insertNode(@NotNull MemoryInfoTreeNode parent, @NotNull MemoryInfoTreeNode child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "insertNode"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "insertNode"));
        }
        this.mTreeModel.insertNodeInto(child, parent, parent.getChildCount());
    }

    @Override
    protected boolean hasLeftContent() {
        return false;
    }

    @Override
    protected boolean hasRightContent() {
        return false;
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "setCenterContent"));
        }
        panel.add((Component)this.mColumnTree, "Center");
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        if (animatables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "animatables", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment", "createComponentsList"));
        }
        this.mTreeModel = new DefaultTreeModel(this.mRoot);
        this.mTree = new Tree((TreeModel)this.mTreeModel);
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.mTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MemoryInfoColumnRenderer(0, this.mRoot))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Count").setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MemoryInfoColumnRenderer(1, this.mRoot)).setInitialOrder(SortOrder.DESCENDING).setComparator((a, b) -> a.getCount() - b.getCount()));
        builder.setTreeSorter((comparator, sortOrder) -> {
            this.mRoot.sort(comparator);
            this.mTreeModel.nodeStructureChanged(this.mRoot);
        });
        this.mColumnTree = builder.build();
    }

    private static class MemoryInfoHealthBar
    extends JComponent {
        private float mDelta;

        private MemoryInfoHealthBar() {
        }

        private void setDelta(float delta) {
            this.mDelta = delta;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dim = this.getSize();
            if (this.mDelta > 0.0f) {
                g.setColor(NEGATIVE_COLOR);
            } else {
                g.setColor(POSITIVE_COLOR);
            }
            g.fillRect(0, 0, (int)((float)dim.width * Math.abs(this.mDelta)), dim.height);
        }
    }

    private static class MemoryInfoColumnRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final MemoryInfoHealthBar mHealthBar;
        @NotNull
        private final MemoryInfoTreeNode mRoot;
        private final int mColumnIndex;

        private MemoryInfoColumnRenderer(int index, @NotNull MemoryInfoTreeNode root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment$MemoryInfoColumnRenderer", "<init>"));
            }
            this.mHealthBar = new MemoryInfoHealthBar();
            this.mColumnIndex = index;
            this.mRoot = root;
            if (this.mColumnIndex > 0) {
                this.setLayout(new BorderLayout());
                this.add(this.mHealthBar, "Center");
            }
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment$MemoryInfoColumnRenderer", "customizeCellRenderer"));
            }
            if (value instanceof MemoryInfoTreeNode) {
                MemoryInfoTreeNode node = (MemoryInfoTreeNode)value;
                switch (this.mColumnIndex) {
                    case 0: {
                        this.append(node.getName());
                        break;
                    }
                    case 1: {
                        this.append(String.valueOf(node.getCount()));
                    }
                }
                this.mHealthBar.setDelta((float)node.getCount() / (float)this.mRoot.getCount());
            }
        }
    }
}

