/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.model;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.hash.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HttpDataCache {
    private final IDevice myDevice;
    private final Map<String, File> myFiles;

    public HttpDataCache(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/ui/network/model/HttpDataCache", "<init>"));
        }
        this.myFiles = new HashMap();
        this.myDevice = device;
    }

    public File getFile(String path) {
        File tempFile = this.myFiles.get(path);
        if (tempFile == null) {
            int fileNameStartIndex = path.lastIndexOf(92);
            String fileName = fileNameStartIndex >= 0 ? path.substring(fileNameStartIndex) : path;
            try {
                tempFile = FileUtil.createTempFile((String)fileName, null);
                tempFile.deleteOnExit();
                this.myDevice.pullFile(path, tempFile.getAbsolutePath());
                this.myFiles.put(path, tempFile);
            }
            catch (AdbCommandRejectedException | SyncException | TimeoutException | IOException throwable) {
                // empty catch block
            }
        }
        return tempFile;
    }
}

