/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.nodes.NativeAndroidLibraryNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleNode
extends ProjectViewModuleNode {
    public NdkModuleNode(@NotNull Project project, @NotNull Module value, ViewSettings viewSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "<init>"));
        }
        super(project, value, viewSettings);
    }

    @NotNull
    public static Collection<AbstractTreeNode> getNativeSourceNodes(@NotNull Project project, @NotNull NdkModuleModel ndkModuleModel, @NotNull ViewSettings viewSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "getNativeSourceNodes"));
        }
        if (ndkModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkModuleModel", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "getNativeSourceNodes"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "getNativeSourceNodes"));
        }
        NativeAndroidProject nativeAndroidProject = ndkModuleModel.getAndroidProject();
        Set<String> sourceFileExtensions = nativeAndroidProject.getFileExtensions().keySet();
        NdkModuleModel.NdkVariant variant = ndkModuleModel.getSelectedVariant();
        HashMultimap nativeLibraries = HashMultimap.create();
        for (NativeArtifact artifact : variant.getArtifacts()) {
            String artifactOutputFileName = artifact.getOutputFile().getName();
            nativeLibraries.put((Object)artifactOutputFileName, (Object)artifact);
        }
        if (nativeLibraries.keySet().size() == 1) {
            Collection<AbstractTreeNode> collection = NativeAndroidLibraryNode.getSourceDirectoryNodes(project, nativeLibraries.values(), viewSettings, sourceFileExtensions);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "getNativeSourceNodes"));
            }
            return collection;
        }
        ArrayList children = Lists.newArrayList();
        for (String name : nativeLibraries.keySet()) {
            String nativeLibraryType = "";
            String nativeLibraryName = StringUtil.trimEnd((String)name, (String)".so");
            if (nativeLibraryName.length() < name.length()) {
                nativeLibraryType = "Shared Library";
            } else {
                nativeLibraryName = StringUtil.trimEnd((String)name, (String)".a");
                if (nativeLibraryName.length() < name.length()) {
                    nativeLibraryType = "Static Library";
                }
            }
            nativeLibraryName = StringUtil.trimStart((String)nativeLibraryName, (String)"lib");
            children.add(new NativeAndroidLibraryNode(project, nativeLibraryName, nativeLibraryType, nativeLibraries.get((Object)name), viewSettings, sourceFileExtensions));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "getNativeSourceNodes"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = (Module)this.getValue();
        if (module == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "getChildren"));
            }
            return immutableList;
        }
        NdkFacet facet = NdkFacet.getInstance(module);
        if (facet == null || facet.getNdkModuleModel() == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "getChildren"));
            }
            return immutableList;
        }
        Collection<AbstractTreeNode> collection = NdkModuleNode.getNativeSourceNodes(this.myProject, facet.getNdkModuleModel(), this.getSettings());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NdkModuleNode", "getChildren"));
        }
        return collection;
    }

    @Nullable
    public Comparable getSortKey() {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return module.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return String.format("%1$s (Native-Android-Gradle)", ((Module)this.getValue()).getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

