/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.ActivityGalleryStep;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateEntry {
    private final File myTemplate;
    private final TemplateMetadata myMetadata;

    public TemplateEntry(File template, TemplateMetadata metadata) {
        this.myTemplate = template;
        this.myMetadata = metadata;
    }

    @Nullable
    public Image getImage() {
        String thumb = this.myMetadata.getThumbnailPath();
        if (thumb != null && !thumb.isEmpty()) {
            try {
                File file = new File(this.myTemplate, thumb.replace('/', File.separatorChar));
                if (file.isFile()) {
                    return ImageIO.read(file);
                }
                return null;
            }
            catch (IOException e) {
                Logger.getInstance(ActivityGalleryStep.class).warn((Throwable)e);
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myTemplate, this.getTitle()});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TemplateEntry another = (TemplateEntry)obj;
        return Objects.equal((Object)this.myTemplate, (Object)another.myTemplate) && Objects.equal((Object)this.getTitle(), (Object)another.getTitle());
    }

    public Template getTemplate() {
        return Template.createFromPath(this.myTemplate);
    }

    @NotNull
    public TemplateMetadata getMetadata() {
        TemplateMetadata templateMetadata = this.myMetadata;
        if (templateMetadata == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateEntry", "getMetadata"));
        }
        return templateMetadata;
    }

    @Nullable
    public String getTitle() {
        return this.myMetadata.getTitle();
    }

    @Nullable
    public String getDescription() {
        return this.getMetadata().getDescription();
    }

    public int getMinBuildApi() {
        return this.getMetadata().getMinBuildApi();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("title", (Object)this.getTitle()).add("path", (Object)this.myTemplate.getAbsolutePath()).toString();
    }

    public int getMinSdk() {
        return this.getMetadata().getMinSdk();
    }

    public Collection<Parameter> getParameters() {
        return this.getMetadata().getParameters();
    }

    public File getTemplateDir() {
        return this.myTemplate;
    }
}

