/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.CharMatcher;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardUtils {
    private static final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>!;]");
    private static final int WINDOWS_PATH_LENGTH_LIMIT = 100;

    @NotNull
    public static String computeModuleName(@NotNull String appName, @Nullable Project project) {
        if (appName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appName", "com/android/tools/idea/npw/WizardUtils", "computeModuleName"));
        }
        String moduleName = appName.toLowerCase(Locale.US).replaceAll("[/\\\\?%*:|\"<>!;]", "");
        if (!WizardUtils.isUniqueModuleName(moduleName = moduleName.replaceAll("\\s", ""), project)) {
            int i = 2;
            while (!WizardUtils.isUniqueModuleName(moduleName + Integer.toString(i), project)) {
                ++i;
            }
            moduleName = moduleName + Integer.toString(i);
        }
        String string = moduleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "computeModuleName"));
        }
        return string;
    }

    @NotNull
    public static File getProjectLocationParent() {
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent == null) {
            String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
            File file = new File(SystemProperties.getUserHome(), child);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "getProjectLocationParent"));
            }
            return file;
        }
        File file = new File(parent.replace('/', File.separatorChar));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "getProjectLocationParent"));
        }
        return file;
    }

    public static boolean isUniqueModuleName(@NotNull String moduleName, @Nullable Project project) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/npw/WizardUtils", "isUniqueModuleName"));
        }
        if (project == null) {
            return true;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module m : moduleManager.getModules()) {
            if (!m.getName().equalsIgnoreCase(moduleName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static File[] listFiles(@Nullable File dir) {
        File[] files;
        if (dir != null && (files = dir.listFiles()) != null) {
            if (files == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "listFiles"));
            }
            return files;
        }
        if (ArrayUtil.EMPTY_FILE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "listFiles"));
        }
        return ArrayUtil.EMPTY_FILE_ARRAY;
    }

    @NotNull
    public static ValidationResult validateLocation(@Nullable String projectLocation) {
        ValidationResult validationResult = WizardUtils.validateLocation(projectLocation, "project location", true);
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
        }
        return validationResult;
    }

    @NotNull
    public static ValidationResult validateLocation(@Nullable String projectLocation, @NotNull String fieldName, boolean checkEmpty) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
        }
        ValidationResult validationResult = WizardUtils.validateLocation(projectLocation, fieldName, checkEmpty, WritableCheckMode.NOT_WRITABLE_IS_ERROR);
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
        }
        return validationResult;
    }

    @NotNull
    public static ValidationResult validateLocation(@Nullable String projectLocation, @NotNull String fieldName, boolean checkEmpty, @NotNull WritableCheckMode writableCheckMode) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
        }
        if (writableCheckMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writableCheckMode", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
        }
        ValidationResult warningResult = null;
        if (projectLocation == null || projectLocation.isEmpty()) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.NO_LOCATION_SPECIFIED, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (File.separatorChar == '/' && projectLocation.contains("\\") || File.separatorChar == '\\' && projectLocation.contains("/")) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.BAD_SLASHES, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        File testFile = new File(projectLocation);
        while (testFile != null) {
            String filename = testFile.getName();
            if (ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)filename)) {
                char illegalChar = filename.charAt(ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)filename));
                ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.ILLEGAL_CHARACTER, fieldName, Character.valueOf(illegalChar), filename);
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
                }
                return validationResult;
            }
            if (WizardConstants.INVALID_WINDOWS_FILENAMES.contains(filename.toLowerCase(Locale.US))) {
                ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.ILLEGAL_FILENAME, fieldName, filename);
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
                }
                return validationResult;
            }
            if (CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)filename)) {
                warningResult = ValidationResult.warn(ValidationResult.Message.WHITESPACE, fieldName, new Object[0]);
            }
            if (!CharMatcher.ASCII.matchesAllOf((CharSequence)filename)) {
                if (SystemInfo.isWindows) {
                    ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.NON_ASCII_CHARS_ERROR, fieldName, new Object[0]);
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
                    }
                    return validationResult;
                }
                warningResult = ValidationResult.warn(ValidationResult.Message.NON_ASCII_CHARS_WARNING, fieldName, new Object[0]);
            }
            File parent = testFile.getParentFile();
            if (!writableCheckMode.equals((Object)WritableCheckMode.DO_NOT_CHECK) && !testFile.exists() && parent != null && parent.exists() && !parent.canWrite()) {
                ValidationResult validationResult = ValidationResult.pathNotWritable(WritableCheckMode.NOT_WRITABLE_IS_ERROR, fieldName, parent);
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
                }
                return validationResult;
            }
            testFile = parent;
        }
        if (SystemInfo.isWindows && projectLocation.length() > 100) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.PATH_TOO_LONG, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        File file = new File(projectLocation);
        if (file.isFile()) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.PROJECT_LOC_IS_FILE, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (file.getParent() == null) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.PROJECT_IS_FILE_SYSTEM_ROOT, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (file.getParentFile().exists() && !file.getParentFile().isDirectory()) {
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.PARENT_NOT_DIR, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (!writableCheckMode.equals((Object)WritableCheckMode.DO_NOT_CHECK) && file.exists() && !file.canWrite()) {
            ValidationResult validationResult = ValidationResult.pathNotWritable(writableCheckMode, fieldName, file);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        String installLocation = PathManager.getHomePathFor(Application.class);
        if (installLocation != null && FileUtil.isAncestor((File)new File(installLocation), (File)file, (boolean)false)) {
            String applicationName = ApplicationNamesInfo.getInstance().getProductName();
            ValidationResult validationResult = ValidationResult.error(ValidationResult.Message.INSIDE_ANDROID_STUDIO, fieldName, applicationName);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        if (checkEmpty && file.exists() && WizardUtils.listFiles(file).length > 0) {
            ValidationResult validationResult = ValidationResult.warn(ValidationResult.Message.NON_EMPTY_DIR, fieldName, new Object[0]);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
            }
            return validationResult;
        }
        ValidationResult validationResult = warningResult == null ? ValidationResult.OK : warningResult;
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils", "validateLocation"));
        }
        return validationResult;
    }

    public static enum WritableCheckMode {
        DO_NOT_CHECK,
        NOT_WRITABLE_IS_ERROR,
        NOT_WRITABLE_IS_WARNING;

    }

    public static class ValidationResult {
        public static final ValidationResult OK = new ValidationResult(Status.OK, null, "any", new Object[0]);
        private final Status myStatus;
        private final Message myMessage;
        private final Object[] myMessageParams;

        private ValidationResult(@NotNull Status status, @Nullable Message message, @NotNull String field, Object ... messageParams) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "<init>"));
            }
            this.myStatus = status;
            this.myMessage = message;
            this.myMessageParams = ArrayUtil.prepend((Object)field, (Object[])messageParams);
        }

        public static ValidationResult warn(@NotNull Message message, String field, Object ... params) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "warn"));
            }
            return new ValidationResult(Status.WARN, message, field, params);
        }

        public static ValidationResult error(@NotNull Message message, String field, Object ... params) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "error"));
            }
            return new ValidationResult(Status.ERROR, message, field, params);
        }

        @NotNull
        private static ValidationResult pathNotWritable(@NotNull WritableCheckMode mode, @NotNull String field, @NotNull File file) {
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "pathNotWritable"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "pathNotWritable"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "pathNotWritable"));
            }
            switch (mode) {
                case NOT_WRITABLE_IS_ERROR: {
                    ValidationResult validationResult = ValidationResult.error(Message.PATH_NOT_WRITABLE, field, file.getPath());
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "pathNotWritable"));
                    }
                    return validationResult;
                }
                case NOT_WRITABLE_IS_WARNING: {
                    ValidationResult validationResult = ValidationResult.warn(Message.PATH_NOT_WRITABLE, field, file.getPath());
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "pathNotWritable"));
                    }
                    return validationResult;
                }
            }
            throw new IllegalArgumentException(mode.toString());
        }

        public String getFormattedMessage() {
            if (this.myMessage == null) {
                throw new IllegalStateException("Null message, are you trying to get the message of an OK?");
            }
            return String.format(this.myMessage.toString(), this.myMessageParams);
        }

        @NotNull
        public Status getStatus() {
            Status status = this.myStatus;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/WizardUtils$ValidationResult", "getStatus"));
            }
            return status;
        }

        public boolean isError() {
            return this.myStatus.equals((Object)Status.ERROR);
        }

        public boolean isOk() {
            return this.myStatus.equals((Object)Status.OK);
        }

        public static enum Message {
            NO_LOCATION_SPECIFIED("Please specify a %1$s"),
            BAD_SLASHES("Your %1$s contains incorrect slashes ('\\' vs '/')"),
            ILLEGAL_CHARACTER("Illegal character in %1$s path: '%2$c' in filename %3s"),
            ILLEGAL_FILENAME("Illegal filename in %1$s path: %2$s"),
            WHITESPACE("%1$s should not contain whitespace, as this can cause problems with the NDK tools."),
            NON_ASCII_CHARS_WARNING("Your %1$s contains non-ASCII characters, which can cause problems. Proceed with caution."),
            NON_ASCII_CHARS_ERROR("Your %1$s contains non-ASCII characters."),
            PATH_NOT_WRITABLE("The path '%2$s' is not writable. Please choose a new location."),
            PROJECT_LOC_IS_FILE("There must not already be a file at the %1$s."),
            NON_EMPTY_DIR("A non-empty directory already exists at the specified %1$s. Existing files may be overwritten. Proceed with caution."),
            PROJECT_IS_FILE_SYSTEM_ROOT("The %1$s can not be at the filesystem root"),
            PARENT_NOT_DIR("The %1$s's parent directory must be a directory, not a plain file"),
            INSIDE_ANDROID_STUDIO("The %1$s is inside %2$s install location"),
            PATH_TOO_LONG("The %1$s is too long");

            private final String myText;

            private Message(String text) {
                this.myText = text;
            }

            public String toString() {
                return this.myText;
            }
        }

        public static enum Status {
            OK,
            WARN,
            ERROR;

        }
    }
}

