/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.MaterialDesignIcons;
import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.ui.SearchField;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class IconPickerDialog
extends DialogWrapper {
    private static final String DEFAULT_ICON_NAME = "action/ic_android_black_24dp.xml";
    private static final String[] ICON_CATEGORIES = IconPickerDialog.initIconCategories();
    private static final String ALL_CATEGORY = ICON_CATEGORIES[0];
    private static final int COLUMN_NUMBER = 6;
    private static final int ICON_ROW_HEIGHT = JBUI.scale((int)64);
    private final Multimap<String, VdIcon> myCategoryIcons;
    private final List<VdIcon> myIconList;
    private final List<VdIcon> myFilteredIconList;
    private final AbstractTableModel myModel;
    private final JBTable myIconTable;
    private JPanel myContentPanel;
    private JPanel myCategoriesPanel;
    private JPanel myIconsPanel;
    private JPanel myLicensePanel;
    private HyperlinkLabel myLicenseLabel;
    private SearchField mySearchField;
    private VdIcon mySelectedIcon;

    private static String[] initIconCategories() {
        Collection categories = MaterialDesignIcons.getCategories();
        ArrayList<String> allAndCategories = new ArrayList<String>(categories.size() + 1);
        allAndCategories.add("All");
        allAndCategories.addAll(categories);
        return allAndCategories.toArray(new String[0]);
    }

    public IconPickerDialog(VdIcon selectedIcon) {
        super(false);
        this.$$$setupUI$$$();
        this.myCategoryIcons = TreeMultimap.create();
        this.myIconList = Lists.newArrayListWithCapacity((int)1000);
        this.myFilteredIconList = Lists.newArrayListWithCapacity((int)1000);
        this.myModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return VdIcon.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                int index = rowIndex * 6 + columnIndex;
                if (index < 0) {
                    return null;
                }
                return IconPickerDialog.this.myFilteredIconList.size() > index ? IconPickerDialog.this.myFilteredIconList.get(index) : null;
            }

            @Override
            public int getRowCount() {
                return IconPickerDialog.this.myFilteredIconList.size() / 6 + (IconPickerDialog.this.myFilteredIconList.size() % 6 == 0 ? 0 : 1);
            }

            @Override
            public int getColumnCount() {
                return 6;
            }
        };
        this.myIconTable = new JBTable((TableModel)this.myModel);
        this.mySelectedIcon = null;
        this.setTitle("Select Icon");
        this.initializeIconMap();
        JBList categoryList = new JBList((Object[])ICON_CATEGORIES);
        JBScrollPane categoryPane = new JBScrollPane((Component)categoryList);
        this.myCategoriesPanel.add((Component)categoryPane);
        Color iconBackgroundColor = UIUtil.getListBackground();
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                VdIcon icon = (VdIcon)value;
                this.setText("");
                this.setIcon((Icon)icon);
                String displayName = icon != null ? icon.getDisplayName() : "";
                AccessibleContextUtil.setName((JComponent)this, (String)displayName);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table.getValueAt(row, column) == null) {
                    Component cell = super.getTableCellRendererComponent(table, value, false, false, row, column);
                    cell.setFocusable(false);
                    return cell;
                }
                JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setFont((Font)JBUI.Fonts.miniFont());
                if (!isSelected) {
                    component.setBackground((Color)JBColor.WHITE);
                }
                component.setForeground(isSelected ? table.getSelectionForeground() : JBColor.GRAY);
                return component;
            }
        };
        this.myIconTable.setBackground(iconBackgroundColor);
        this.myIconTable.setDefaultRenderer(VdIcon.class, (TableCellRenderer)tableRenderer);
        this.myIconTable.setRowHeight(ICON_ROW_HEIGHT);
        this.myIconTable.setSelectionMode(0);
        this.myIconTable.setCellSelectionEnabled(true);
        this.myIconsPanel.add((Component)new JBScrollPane((Component)this.myIconTable));
        this.myIconTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                    IconPickerDialog.this.mySearchField.setText(Character.toString(keyChar));
                    IconPickerDialog.this.mySearchField.requestFocus();
                }
                super.keyPressed(e);
            }
        });
        this.myLicenseLabel.setHyperlinkText("These icons are available under the ", "Apache License Version 2.0", "");
        this.myLicenseLabel.setHyperlinkTarget("http://www.apache.org/licenses/LICENSE-2.0.txt");
        ListSelectionModel selModel = this.myIconTable.getSelectionModel();
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.myIconTable.setGridColor(iconBackgroundColor);
        this.myIconTable.setIntercellSpacing((Dimension)JBUI.size((int)3, (int)3));
        this.myIconTable.setRowMargin(0);
        ListSelectionListener listener = e -> {
            VdIcon icon;
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = this.myIconTable.getSelectedRow();
            int col = this.myIconTable.getSelectedColumn();
            this.mySelectedIcon = icon = row != -1 && col != -1 ? (VdIcon)this.myIconTable.getValueAt(row, col) : null;
            this.setOKActionEnabled(icon != null);
        };
        selModel.addListSelectionListener(listener);
        ListSelectionModel colSelModel = this.myIconTable.getColumnModel().getSelectionModel();
        colSelModel.addListSelectionListener(listener);
        categoryList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            String selectedValue = (String)categoryList.getSelectedValue();
            if (selectedValue != null) {
                this.updateIconList(selectedValue);
            }
        });
        categoryList.setSelectedIndex(0);
        selModel.setSelectionMode(0);
        selModel.setSelectionInterval(0, 0);
        this.myIconTable.setColumnSelectionInterval(0, 0);
        this.myIconTable.requestFocusInWindow();
        if (selectedIcon != null) {
            this.initializeSelection(selectedIcon);
        }
        this.init();
    }

    private void createUIComponents() {
        this.mySearchField = new SearchField(false);
        this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                IconPickerDialog.this.updateFilter();
            }
        });
    }

    private void updateFilter() {
        String text = this.mySearchField.getText().trim();
        this.myFilteredIconList.clear();
        for (VdIcon icon : this.myIconList) {
            if (!text.isEmpty() && !StringUtil.containsIgnoreCase((String)icon.getDisplayName(), (String)text)) continue;
            this.myFilteredIconList.add(icon);
        }
        this.myModel.fireTableDataChanged();
    }

    public static VdIcon getDefaultIcon() {
        URL url = GraphicGenerator.class.getClassLoader().getResource("images/material_design_icons/action/ic_android_black_24dp.xml");
        assert (url != null);
        try {
            return new VdIcon(url);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private void initializeSelection(@NotNull VdIcon selectedIcon) {
        if (selectedIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedIcon", "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog", "initializeSelection"));
        }
        for (int r = 0; r < this.myIconTable.getRowCount(); ++r) {
            for (int c = 0; c < this.myIconTable.getColumnCount(); ++c) {
                VdIcon icon = (VdIcon)this.myIconTable.getValueAt(r, c);
                if (!icon.getURL().equals(selectedIcon.getURL())) continue;
                this.myIconTable.changeSelection(r, c, false, false);
                return;
            }
        }
    }

    private void initializeIconMap() {
        for (int i = 1; i < ICON_CATEGORIES.length; ++i) {
            String categoryName = ICON_CATEGORIES[i];
            String categoryNameLowerCase = categoryName.toLowerCase(Locale.ENGLISH);
            String fullDirName = "images/material_design_icons/" + categoryNameLowerCase + '/';
            Iterator iterator = GraphicGenerator.getResourcesNames((String)fullDirName, (String)".xml");
            while (iterator.hasNext()) {
                String iconName = (String)iterator.next();
                URL url = GraphicGenerator.class.getClassLoader().getResource(fullDirName + iconName);
                assert (url != null);
                try {
                    VdIcon icon = new VdIcon(url);
                    icon.setShowName(true);
                    this.myCategoryIcons.put((Object)categoryName, (Object)icon);
                }
                catch (IOException iOException) {}
            }
        }
        this.myCategoryIcons.putAll((Object)ALL_CATEGORY, (Iterable)this.myCategoryIcons.values());
    }

    public VdIcon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    JTable getTable() {
        return this.myIconTable;
    }

    void setFilter(String text) {
        this.mySearchField.setText(text);
    }

    private void updateIconList(@NotNull String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryName", "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog", "updateIconList"));
        }
        this.myIconList.clear();
        assert (this.myCategoryIcons.containsKey((Object)categoryName)) : String.format("Category '%1$s' is not populated. List of populated categories: %2$s", categoryName, Joiner.on((String)",").join((Iterable)this.myCategoryIcons.keySet()));
        this.myIconList.addAll(this.myCategoryIcons.get((Object)categoryName));
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.updateFilter();
        this.myIconTable.setColumnSelectionInterval(0, 0);
        this.myIconTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myContentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(20, 20));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, "West");
        this.myCategoriesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, "Center");
        SearchField searchField = this.mySearchField;
        jPanel5.add((Component)((Object)searchField), "North");
        this.myIconsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "Center");
        this.myLicensePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, "South");
        this.myLicenseLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

