/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.idea.lint.AndroidLintWebpUnsupportedInspection;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertFromWebpAction
extends DumbAwareAction {
    @Nls(capitalization=Nls.Capitalization.Title)
    public static final String TITLE = "Convert from WebP to PNG";

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        int answer = Messages.showYesNoCancelDialog((Project)project, (String)"Delete .webp files after saving as .png?", (String)TITLE, null);
        if (answer == 2) {
            return;
        }
        boolean delete = answer == 0;
        VirtualFile[] files = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        this.perform(project, files, delete);
    }

    public void perform(@NotNull Project project, @NotNull VirtualFile[] files, boolean deleteWebp) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction", "perform"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction", "perform"));
        }
        this.convert(project, Arrays.asList(files), deleteWebp);
    }

    public void update(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null && e.getProject() != null) {
            for (VirtualFile file : files) {
                if (!SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".webp")) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void convert(@NotNull Project project, @NotNull Collection<VirtualFile> files, boolean delete) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction", "convert"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction", "convert"));
        }
        ProgressManager.getInstance().run((Task)new WebpConversionTask(project, files, delete));
    }

    private static void refreshFolders(List<VirtualFile> toRefresh) {
        for (VirtualFile dir : toRefresh) {
            dir.refresh(true, true);
        }
    }

    @NotNull
    private static List<VirtualFile> computeParentFolders(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction", "computeParentFolders"));
        }
        ArrayList toRefresh = Lists.newArrayList();
        for (VirtualFile file : files) {
            VirtualFile parent = file.getParent();
            if (parent == null || toRefresh.contains(parent)) continue;
            toRefresh.add(parent);
        }
        ArrayList arrayList = toRefresh;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction", "computeParentFolders"));
        }
        return arrayList;
    }

    static class WebpConversionTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final Collection<VirtualFile> myFiles;
        private final boolean myDelete;
        private List<VirtualFile> myParentFolders;
        private List<VirtualFile> myConvertedFiles;

        public WebpConversionTask(Project project, Collection<VirtualFile> files, boolean delete) {
            super(project, ConvertFromWebpAction.TITLE, true);
            this.myProject = project;
            this.myFiles = files;
            this.myDelete = delete;
        }

        public void onFinished() {
            this.writeImages((Object)this, this.myProject, this.myConvertedFiles);
            ConvertFromWebpAction.refreshFolders(this.myParentFolders);
        }

        private void writeImages(@NotNull Object requestor, @NotNull Project project, @NotNull List<VirtualFile> files) {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask", "writeImages"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask", "writeImages"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask", "writeImages"));
            }
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask", "lambda$writeImages$0"));
                }
                if (requestor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask", "lambda$writeImages$0"));
                }
                for (VirtualFile file : files) {
                    try {
                        BufferedImage image;
                        if (!file.isValid() || (image = ImageIO.read(file.getInputStream())) == null) continue;
                        ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                        ImageIO.write((RenderedImage)image, "PNG", stream);
                        byte[] encoded = stream.toByteArray();
                        VirtualFile folder = file.getParent();
                        VirtualFile output = folder.createChildData(requestor, file.getNameWithoutExtension() + ".png");
                        try (BufferedOutputStream fos = new BufferedOutputStream(output.getOutputStream((Object)this));){
                            ((OutputStream)fos).write(encoded);
                        }
                        if (!this.myDelete) continue;
                        file.delete(requestor);
                    }
                    catch (IOException e) {
                        Logger.getInstance(AndroidLintWebpUnsupportedInspection.class).warn(e.getMessage());
                    }
                }
            });
        }

        public void run(@NotNull ProgressIndicator progressIndicator) {
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask", "run"));
            }
            LinkedList<VirtualFile> images = new LinkedList<VirtualFile>(this.myFiles);
            this.myConvertedFiles = WebpConversionTask.findImages(progressIndicator, images);
            this.myParentFolders = ConvertFromWebpAction.computeParentFolders(this.myConvertedFiles);
        }

        @NotNull
        private static List<VirtualFile> findImages(@NotNull ProgressIndicator progressIndicator, LinkedList<VirtualFile> images) {
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask", "findImages"));
            }
            ArrayList files = Lists.newArrayList();
            while (!images.isEmpty()) {
                progressIndicator.checkCanceled();
                VirtualFile file = images.pop();
                progressIndicator.setText(file.getPath());
                if (file.isDirectory()) {
                    for (VirtualFile f : file.getChildren()) {
                        images.push(f);
                    }
                    continue;
                }
                if (!SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".webp")) continue;
                files.add(file);
            }
            ArrayList arrayList = files;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/webp/ConvertFromWebpAction$WebpConversionTask", "findImages"));
            }
            return arrayList;
        }
    }
}

