/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ProjectResourceRepositoryRootListener {
    private ProjectResourceRepositoryRootListener(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ProjectResourceRepositoryRootListener", "<init>"));
        }
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ProjectResourceRepositoryRootListener.moduleRootsChanged(project);
            }
        });
    }

    public static void ensureSubscribed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ProjectResourceRepositoryRootListener", "ensureSubscribed"));
        }
        ServiceManager.getService((Project)project, ProjectResourceRepositoryRootListener.class);
    }

    private static void moduleRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/ProjectResourceRepositoryRootListener", "moduleRootsChanged"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            ProjectResourceRepositoryRootListener.moduleRootsChanged(module);
        }
    }

    private static void moduleRootsChanged(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/res/ProjectResourceRepositoryRootListener", "moduleRootsChanged"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            if (facet.requiresAndroidModel() && facet.getAndroidModel() == null) {
                return;
            }
            facet.getResourceFolderManager().invalidate();
            ProjectResourceRepository projectResources = ProjectResourceRepository.getProjectResources(facet, false);
            if (projectResources != null) {
                projectResources.updateRoots();
                AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, false);
                if (appResources != null) {
                    appResources.invalidateCache(projectResources, new ResourceType[0]);
                    appResources.updateRoots();
                }
            }
        }
    }
}

