/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.structure.services.ServiceXmlParser;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class DeveloperService {
    @NotNull
    private final ServiceXmlParser myServiceParser;

    public DeveloperService(@NotNull ServiceXmlParser serviceParser) {
        if (serviceParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceParser", "com/android/tools/idea/structure/services/DeveloperService", "<init>"));
        }
        this.myServiceParser = serviceParser;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myServiceParser.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getModule"));
        }
        return module;
    }

    @NotNull
    public ServiceCategory getCategory() {
        ServiceCategory serviceCategory = this.myServiceParser.getServiceCategory();
        if (serviceCategory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getCategory"));
        }
        return serviceCategory;
    }

    @NotNull
    public DeveloperServiceMetadata getMetadata() {
        DeveloperServiceMetadata developerServiceMetadata = this.myServiceParser.getDeveloperServiceMetadata();
        if (developerServiceMetadata == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getMetadata"));
        }
        return developerServiceMetadata;
    }

    @NotNull
    public ServiceContext getContext() {
        ServiceContext serviceContext = this.myServiceParser.getContext();
        if (serviceContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getContext"));
        }
        return serviceContext;
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myServiceParser.getServicePanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getPanel"));
        }
        return jPanel;
    }

    public void install() {
        Project project = this.myServiceParser.getModule().getProject();
        new WriteCommandAction.Simple(project, "Install " + this.getMetadata().getName(), new PsiFile[0]){

            protected void run() throws Throwable {
                DeveloperService.this.myServiceParser.install();
            }
        }.execute();
        this.getContext().snapshot();
        this.getContext().installed().set(true);
        this.trackEvent(AndroidStudioEvent.EventKind.DEVELOPER_SERVICES_INSTALLED);
    }

    public void uninstall() {
        if (!this.getContext().installed().get().booleanValue()) {
            return;
        }
        Module module = this.getModule();
        BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).removeDependencies(module, this.getMetadata());
        this.getContext().installed().set(false);
        this.trackEvent(AndroidStudioEvent.EventKind.DEVELOPER_SERVICES_REMOVED);
    }

    public boolean isInstalled() {
        return this.getContext().installed().get();
    }

    private void trackEvent(AndroidStudioEvent.EventKind eventKind) {
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEVELOPER_SERVICES).setKind(eventKind).setDeveloperServiceKind(this.serviceIdToServiceKind(this.getMetadata().getId())));
    }

    private AndroidStudioEvent.DeveloperServiceKind serviceIdToServiceKind(String id) {
        switch (id) {
            case "firebase.messaging": 
            case "google_cloud_messaging": {
                return AndroidStudioEvent.DeveloperServiceKind.GOOGLE_CLOUD_MESSAGING;
            }
            case "admob": 
            case "firebase.admob": {
                return AndroidStudioEvent.DeveloperServiceKind.AD_MOB;
            }
            case "google_identity": {
                return AndroidStudioEvent.DeveloperServiceKind.GOOGLE_SIGN_IN;
            }
            case "google_analytics": 
            case "firebase.analytics": {
                return AndroidStudioEvent.DeveloperServiceKind.GOOGLE_ANALYTICS;
            }
            case "firebase.database": {
                return AndroidStudioEvent.DeveloperServiceKind.REALTIME_DATABASE;
            }
            case "firebase.auth": {
                return AndroidStudioEvent.DeveloperServiceKind.AUTHENTICATION;
            }
            case "firebase.crash": {
                return AndroidStudioEvent.DeveloperServiceKind.CRASH_REPORTING;
            }
            case "firebase.notifications": {
                return AndroidStudioEvent.DeveloperServiceKind.NOTIFICATIONS;
            }
            case "firebase.remote_config": {
                return AndroidStudioEvent.DeveloperServiceKind.REMOTE_CONFIG;
            }
            case "firebase.storage": {
                return AndroidStudioEvent.DeveloperServiceKind.STORAGE;
            }
            case "firebase.app_invites": {
                return AndroidStudioEvent.DeveloperServiceKind.APP_INVITES;
            }
            case "firebase.dynamiclinks": {
                return AndroidStudioEvent.DeveloperServiceKind.DYNAMIC_LINKS;
            }
            case "firebase": {
                return AndroidStudioEvent.DeveloperServiceKind.FIREBASE;
            }
        }
        return AndroidStudioEvent.DeveloperServiceKind.UNKNOWN_DEVELOPER_SERVICE_KIND;
    }

    void updateInstalledState() {
        Module module = this.getModule();
        boolean isInstalled = BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).isServiceInstalled(module, this.getMetadata());
        this.getContext().installed().set(isInstalled);
    }
}

