/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.tools.idea.testartifacts.scopes.ExcludedRoots;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestArtifactSearchScopes
implements Disposable {
    private static final Key<TestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    private boolean alreadyResolved;
    @NotNull
    private final Module myModule;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;
    private DependencySet mainDependencies;
    private DependencySet unitTestDependencies;
    private DependencySet androidTestDependencies;

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "get"));
        }
        if (GradleSyncState.getInstance(project).lastSyncFailed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(file);
        return module != null ? TestArtifactSearchScopes.get(module) : null;
    }

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "get"));
        }
        return (TestArtifactSearchScopes)module.getUserData(SEARCH_SCOPES_KEY);
    }

    public static void initializeScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "initializeScope"));
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        TestArtifactSearchScopes scopes = androidModel != null ? new TestArtifactSearchScopes(module) : null;
        module.putUserData(SEARCH_SCOPES_KEY, (Object)scopes);
    }

    private TestArtifactSearchScopes(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "<init>"));
        }
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
        module.putUserData(SEARCH_SCOPES_KEY, (Object)this);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getModule"));
        }
        return module;
    }

    public boolean isAndroidTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "isAndroidTestSource"));
        }
        return this.getAndroidTestSourceScope().accept(file);
    }

    public boolean isUnitTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "isUnitTestSource"));
        }
        return this.getUnitTestSourceScope().accept(file);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestSourceScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getAndroidTestSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestSourceScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getUnitTestSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getSourceScope"));
        }
        Set<File> roots = Collections.emptySet();
        AndroidModuleModel androidModel = this.getAndroidModel();
        if (androidModel != null) {
            roots = new HashSet();
            for (SourceProvider sourceProvider : androidModel.getTestSourceProviders(artifactName)) {
                roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
            }
        }
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), roots);
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getUnitTestSourceScope().exclude(this.getAndroidTestSourceScope());
            this.myAndroidTestExcludeScope = exclude.merge(this.getAndroidTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getAndroidTestExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getAndroidTestSourceScope().exclude(this.getUnitTestSourceScope());
            this.myUnitTestExcludeScope = exclude.merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getUnitTestExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getSharedTestsExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestDependencyExcludeScope().merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.mySharedTestsExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getSharedTestsExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestDependencyExcludeScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludedDependenciesScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getAndroidTestDependencyExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestDependencyExcludeScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludedDependenciesScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getUnitTestDependencyExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getExcludedDependenciesScope(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getExcludedDependenciesScope"));
        }
        if (this.getAndroidModel() == null) {
            FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), Collections.emptyList());
            if (fileRootSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getExcludedDependenciesScope"));
            }
            return fileRootSearchScope;
        }
        this.resolveDependencies();
        boolean isAndroidTest = "_android_test_".equals(artifactName);
        DependencySet dependenciesToInclude = isAndroidTest ? this.androidTestDependencies : this.unitTestDependencies;
        DependencySet dependenciesToExclude = isAndroidTest ? this.unitTestDependencies : this.androidTestDependencies;
        ExcludedModules excludedModules = new ExcludedModules(this.myModule);
        excludedModules.add(dependenciesToExclude);
        excludedModules.remove(dependenciesToInclude);
        excludedModules.remove(this.mainDependencies);
        ExcludedRoots excludedRoots = new ExcludedRoots(this.myModule, excludedModules, dependenciesToExclude, dependenciesToInclude, isAndroidTest);
        excludedRoots.removeLibraryPaths(this.mainDependencies);
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), excludedRoots.get());
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "getExcludedDependenciesScope"));
        }
        return fileRootSearchScope;
    }

    private void mergeSubmoduleDependencies(@NotNull DependencySet original, @Nullable DependencySet toMergeMain, @Nullable DependencySet toMergeAndroid, @Nullable DependencySet toMergeUnit) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "mergeSubmoduleDependencies"));
        }
        HashSet<ModuleDependency> moduleDependencies = new HashSet<ModuleDependency>(original.onModules());
        for (ModuleDependency moduleDependency : moduleDependencies) {
            TestArtifactSearchScopes moduleScope;
            Module module = moduleDependency.getModule(this.myModule.getProject());
            if (module == null || (moduleScope = TestArtifactSearchScopes.get(module)) == null) continue;
            moduleScope.resolveDependencies();
            if (toMergeMain != null) {
                toMergeMain.addAll(moduleScope.mainDependencies);
            }
            if (toMergeAndroid != null) {
                toMergeAndroid.addAll(moduleScope.androidTestDependencies);
            }
            if (toMergeUnit == null) continue;
            toMergeUnit.addAll(moduleScope.unitTestDependencies);
        }
    }

    @VisibleForTesting
    void resolveDependencies() {
        AndroidModuleModel androidModel = this.getAndroidModel();
        if (androidModel == null || this.alreadyResolved) {
            return;
        }
        this.mainDependencies = this.extractMainDependencies(androidModel);
        this.androidTestDependencies = this.extractAndroidTestDependencies(androidModel);
        this.unitTestDependencies = this.extractUnitTestDependencies(androidModel);
        this.mergeSubmoduleDependencies(this.mainDependencies, this.mainDependencies, null, null);
        this.mergeSubmoduleDependencies(this.androidTestDependencies, this.androidTestDependencies, this.androidTestDependencies, null);
        this.mergeSubmoduleDependencies(this.unitTestDependencies, this.unitTestDependencies, null, this.unitTestDependencies);
        this.alreadyResolved = true;
    }

    @NotNull
    private DependencySet extractUnitTestDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "extractUnitTestDependencies"));
        }
        JavaArtifact artifact = androidModel.getUnitTestArtifactInSelectedVariant();
        if (this.unitTestDependencies == null) {
            this.unitTestDependencies = TestArtifactSearchScopes.extractTestDependencies((BaseArtifact)artifact, androidModel.getModelVersion());
        }
        DependencySet dependencySet = this.unitTestDependencies;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "extractUnitTestDependencies"));
        }
        return dependencySet;
    }

    @NotNull
    private DependencySet extractAndroidTestDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "extractAndroidTestDependencies"));
        }
        AndroidArtifact artifact = androidModel.getAndroidTestArtifactInSelectedVariant();
        if (this.androidTestDependencies == null) {
            this.androidTestDependencies = TestArtifactSearchScopes.extractTestDependencies((BaseArtifact)artifact, androidModel.getModelVersion());
        }
        DependencySet dependencySet = this.androidTestDependencies;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "extractAndroidTestDependencies"));
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractTestDependencies(@Nullable BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        DependencySet dependencySet = TestArtifactSearchScopes.extractDependencies(DependencyScope.TEST, artifact, modelVersion);
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "extractTestDependencies"));
        }
        return dependencySet;
    }

    @NotNull
    private DependencySet extractMainDependencies(AndroidModuleModel androidModel) {
        if (this.mainDependencies == null) {
            this.mainDependencies = TestArtifactSearchScopes.extractDependencies(DependencyScope.COMPILE, (BaseArtifact)androidModel.getMainArtifact(), androidModel.getModelVersion());
        }
        DependencySet dependencySet = this.mainDependencies;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "extractMainDependencies"));
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractDependencies(@NotNull DependencyScope scope, @Nullable BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "extractDependencies"));
        }
        DependencySet dependencySet = artifact != null ? DependenciesExtractor.getInstance().extractFrom(artifact, scope, modelVersion) : DependencySet.EMPTY;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes", "extractDependencies"));
        }
        return dependencySet;
    }

    @Nullable
    private AndroidModuleModel getAndroidModel() {
        return this.myModule.isDisposed() ? null : AndroidModuleModel.get(this.myModule);
    }

    public void dispose() {
        this.myModule.putUserData(SEARCH_SCOPES_KEY, null);
    }
}

