/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.menu;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.menu.ActionBar;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GroupDragHandler
extends DragHandler {
    private final NlComponent myGroup;
    private final List<NlComponent> myItems;
    private final ActionBar myActionBar;
    private NlComponent myActiveItem;

    GroupDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent group, @NotNull List<NlComponent> items, @NotNull DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "<init>"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "<init>"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "<init>"));
        }
        super(editor, handler, group, items, type);
        assert (!items.isEmpty());
        this.myGroup = group;
        this.myItems = items;
        this.myActionBar = new ActionBar(group);
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "commit"));
        }
        this.updateOrderInCategoryAttributes();
        this.updateShowAsActionAttribute();
        this.insertComponents(this.getInsertIndex(), insertType);
    }

    private void updateOrderInCategoryAttributes() {
        if (this.myActiveItem == null || this.myActiveItem == this.myItems.get(0)) {
            return;
        }
        Integer order = GroupDragHandler.getOrderInCategory(this.myActiveItem);
        if (order == null) {
            return;
        }
        if (this.isActionBarGroupActive()) {
            this.updateActionBarGroupOrderInCategoryAttributes(order);
        } else {
            this.updateOverflowGroupOrderInCategoryAttributes(order);
        }
    }

    private void updateActionBarGroupOrderInCategoryAttributes(int order) {
        if (this.lastX >= this.myActiveItem.getMidpointX()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBar.getItems()), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private void updateOverflowGroupOrderInCategoryAttributes(int order) {
        if (this.lastY >= this.myActiveItem.getMidpointY()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBar.getOverflowItems()), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private static void incrementOrderInCategoryAttributes(@NotNull Multimap<Integer, NlComponent> orderToItemMultimap, int order) {
        if (orderToItemMultimap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderToItemMultimap", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "incrementOrderInCategoryAttributes"));
        }
        Collection items = orderToItemMultimap.get((Object)order);
        if (!items.isEmpty()) {
            items.forEach(item -> item.setAndroidAttribute("orderInCategory", Integer.toString(order + 1)));
            GroupDragHandler.incrementOrderInCategoryAttributes(orderToItemMultimap, order + 1);
        }
    }

    @NotNull
    private Multimap<Integer, NlComponent> createOrderToItemMultimap(@NotNull Iterable<NlComponent> group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "createOrderToItemMultimap"));
        }
        NlComponent draggedItem = this.myItems.get(0);
        ArrayListMultimap orderToItemMultimap = ArrayListMultimap.create();
        for (NlComponent item : group) {
            Integer order;
            if (item == draggedItem || (order = GroupDragHandler.getOrderInCategory(item)) == null) continue;
            orderToItemMultimap.put((Object)order, (Object)item);
        }
        ArrayListMultimap arrayListMultimap = orderToItemMultimap;
        if (arrayListMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "createOrderToItemMultimap"));
        }
        return arrayListMultimap;
    }

    @Nullable
    private static Integer getOrderInCategory(@NotNull NlComponent item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "getOrderInCategory"));
        }
        String order = item.getAndroidAttribute("orderInCategory");
        return order == null ? null : Ints.tryParse((String)order);
    }

    private void updateShowAsActionAttribute() {
        if (this.isActionBarGroupActive()) {
            this.myItems.get(0).setAttribute(this.getNamespace(), "showAsAction", "always");
        } else {
            this.myItems.get(0).removeAttribute(this.getNamespace(), "showAsAction");
        }
    }

    private String getNamespace() {
        return this.editor.getModel().isModuleDependency("com.android.support:appcompat-v7") ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String message = super.update(x, y, modifiers);
        if (message != null) {
            this.myActiveItem = null;
            return message;
        }
        if (this.isActionBarGroupActive()) {
            this.updateUsingActionBarGroup();
        } else if (this.isOverflowGroupActive()) {
            this.updateUsingOverflowGroup();
        } else {
            this.myActiveItem = null;
        }
        return null;
    }

    private void updateUsingActionBarGroup() {
        List<NlComponent> items = this.myActionBar.getItems();
        if (this.lastX < items.get((int)0).x) {
            this.myActiveItem = items.get(0);
        } else {
            Optional<NlComponent> activeItem = items.stream().filter(item -> item.containsX(this.lastX)).findFirst();
            this.myActiveItem = activeItem.orElse(items.get(items.size() - 1));
        }
    }

    private void updateUsingOverflowGroup() {
        List<NlComponent> overflowItems = this.myActionBar.getOverflowItems();
        if (this.lastY < overflowItems.get((int)0).y) {
            this.myActiveItem = overflowItems.get(0);
        } else {
            Optional<NlComponent> activeItem = overflowItems.stream().filter(item -> item.containsY(this.lastY)).findFirst();
            this.myActiveItem = activeItem.orElse(overflowItems.get(overflowItems.size() - 1));
        }
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "paint"));
        }
        if (this.isActionBarGroupActive()) {
            this.drawActionBarGroupDropPreviewLine(graphics);
            this.drawActionBarGroupDropRecipientLines(graphics);
            this.drawActionBarGroupDropZoneLines(graphics);
        } else if (this.isOverflowGroupActive()) {
            this.drawOverflowGroupDropPreviewLine(graphics);
            this.drawOverflowGroupDropRecipientLines(graphics);
            this.drawOverflowGroupDropZoneLines(graphics);
        }
    }

    private void drawActionBarGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "drawActionBarGroupDropPreviewLine"));
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.lastX < this.myActiveItem.getMidpointX()) {
            graphics.drawLeft(this.myActiveItem);
        } else {
            graphics.drawRight(this.myActiveItem);
        }
    }

    private void drawActionBarGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "drawActionBarGroupDropRecipientLines"));
        }
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        assert (itemBounds != null);
        List<NlComponent> items = this.myActionBar.getItems();
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        graphics.drawTop(itemBounds);
        if (this.lastX >= items.get(0).getMidpointX()) {
            graphics.drawLeft(itemBounds);
        }
        if (this.lastX < items.get(items.size() - 1).getMidpointX()) {
            graphics.drawRight(itemBounds);
        }
        graphics.drawBottom(itemBounds);
    }

    private void drawActionBarGroupDropZoneLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "drawActionBarGroupDropZoneLines"));
        }
        List<NlComponent> items = this.myActionBar.getItems();
        int midpointX = this.myActiveItem.getMidpointX();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = items.size();
        for (int i = 1; i < size; ++i) {
            NlComponent item = items.get(i);
            if (this.myActiveItem == items.get(i - 1)) {
                if (this.lastX >= midpointX) continue;
                graphics.drawLeft(item);
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastX < midpointX) continue;
                graphics.drawLeft(item);
                continue;
            }
            graphics.drawLeft(item);
        }
    }

    private void drawOverflowGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "drawOverflowGroupDropPreviewLine"));
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.lastY < this.myActiveItem.getMidpointY()) {
            graphics.drawTop(this.myActiveItem);
        } else {
            graphics.drawBottom(this.myActiveItem);
        }
    }

    private void drawOverflowGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "drawOverflowGroupDropRecipientLines"));
        }
        List<NlComponent> overflowItems = this.myActionBar.getOverflowItems();
        Rectangle overflowItemBounds = this.myActionBar.getOverflowItemBounds();
        assert (overflowItemBounds != null);
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        if (this.lastY >= overflowItems.get(0).getMidpointY()) {
            graphics.drawTop(overflowItemBounds);
        }
        graphics.drawLeft(overflowItemBounds);
        graphics.drawRight(overflowItemBounds);
        if (this.lastY < overflowItems.get(overflowItems.size() - 1).getMidpointY()) {
            graphics.drawBottom(overflowItemBounds);
        }
    }

    private void drawOverflowGroupDropZoneLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler", "drawOverflowGroupDropZoneLines"));
        }
        List<NlComponent> overflowItems = this.myActionBar.getOverflowItems();
        int midpointY = this.myActiveItem.getMidpointY();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = overflowItems.size();
        for (int i = 1; i < size; ++i) {
            NlComponent item = overflowItems.get(i);
            if (this.myActiveItem == overflowItems.get(i - 1)) {
                if (this.lastY >= midpointY) continue;
                graphics.drawTop(item);
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastY < midpointY) continue;
                graphics.drawTop(item);
                continue;
            }
            graphics.drawTop(item);
        }
    }

    int getInsertIndex() {
        if (this.isActionBarGroupActive()) {
            return this.getInsertIndexUsingActionBarGroup();
        }
        if (this.isOverflowGroupActive()) {
            return this.getInsertIndexUsingOverflowGroup();
        }
        return -1;
    }

    private int getInsertIndexUsingActionBarGroup() {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        assert (itemBounds != null);
        if (this.lastX < itemBounds.x) {
            return 0;
        }
        if (this.lastX >= itemBounds.x + itemBounds.width) {
            return -1;
        }
        int i = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i != -1);
        if (this.lastX >= this.myActiveItem.getMidpointX()) {
            ++i;
        }
        return i == this.myGroup.getChildCount() ? -1 : i;
    }

    private int getInsertIndexUsingOverflowGroup() {
        Rectangle overflowItemBounds = this.myActionBar.getOverflowItemBounds();
        assert (overflowItemBounds != null);
        if (this.lastY < overflowItemBounds.y) {
            return 0;
        }
        if (this.lastY >= overflowItemBounds.y + overflowItemBounds.height) {
            return -1;
        }
        int i = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i != -1);
        if (this.lastY >= this.myActiveItem.getMidpointY()) {
            ++i;
        }
        return i == this.myGroup.getChildCount() ? -1 : i;
    }

    private boolean isActionBarGroupActive() {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        return itemBounds != null && this.lastY < itemBounds.y + itemBounds.height;
    }

    private boolean isOverflowGroupActive() {
        return this.myActionBar.getOverflowItemBounds() != null;
    }
}

