/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.menu;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.menu.MenuHandler;
import com.android.tools.idea.uibuilder.handlers.menu.SearchItemHandler;
import com.android.tools.idea.uibuilder.handlers.menu.SwitchItemHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHandler
extends MenuHandler {
    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent group, @NotNull List<NlComponent> items, @NotNull DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "createDragHandler"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "createDragHandler"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "createDragHandler"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "createDragHandler"));
        }
        return null;
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "onCreate"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "onCreate"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "onCreate"));
        }
        if (SearchItemHandler.handles(newChild)) {
            return new SearchItemHandler().onCreate(editor, parent, newChild, type);
        }
        if (SwitchItemHandler.handles(newChild)) {
            return new SwitchItemHandler().onCreate(editor, parent, newChild, type);
        }
        return super.onCreate(editor, parent, newChild, type);
    }

    @Override
    public boolean acceptsChild(@NotNull NlComponent parent, @NotNull NlComponent newChild) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "acceptsChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "acceptsChild"));
        }
        return newChild.getTagName().equals("menu");
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "getTitle"));
        }
        String string = Strings.nullToEmpty((String)item.getAndroidAttribute("title"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "getTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"id", (Object)"title", (Object)"icon", (Object)"showAsAction", (Object)"visible", (Object)"enabled", (Object)"checkable");
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/menu/ItemHandler", "getInspectorProperties"));
        }
        return immutableList;
    }
}

