/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintPainter;
import com.android.tools.idea.uibuilder.handlers.relative.GuidelinePainter;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeDragHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeResizeHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeLayoutHandler
extends ViewGroupHandler {
    @Override
    public boolean paintConstraints(@NotNull ScreenView screenView, @NotNull Graphics2D graphics, @NotNull NlComponent component) {
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "paintConstraints"));
        }
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "paintConstraints"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "paintConstraints"));
        }
        NlGraphics g = new NlGraphics(graphics, screenView);
        List<NlComponent> iterable = component.getChildren();
        ArrayList children = Lists.newArrayList(iterable);
        ConstraintPainter.paintSelectionFeedback(g, component, children, true, TextDirection.LEFT_TO_RIGHT);
        return false;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "createDragHandler"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "createDragHandler"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "createDragHandler"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "createDragHandler"));
        }
        final RelativeDragHandler moveHandler = new RelativeDragHandler(editor, layout, components);
        return new DragHandler(editor, this, layout, components, type){

            @Override
            @Nullable
            public String update(int x, int y, int modifiers) {
                super.update(x, y, modifiers);
                NlComponent primary = (NlComponent)this.components.get(0);
                int deltaX = this.lastX - this.startX;
                int deltaY = this.lastY - this.startY;
                moveHandler.updateMove(primary, deltaX, deltaY, modifiers);
                return null;
            }

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                if (graphics == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$1", "paint"));
                }
                GuidelinePainter.paint(graphics, moveHandler);
            }

            @Override
            public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
                if (insertType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$1", "commit"));
                }
                moveHandler.removeCycles();
                NlComponent previous = null;
                for (NlComponent component : this.components) {
                    if (previous == null) {
                        moveHandler.applyConstraints(component);
                    } else {
                        moveHandler.attachPrevious(previous, component);
                    }
                    previous = component;
                }
                this.insertAddedComponents(insertType);
            }

            private void insertAddedComponents(@NotNull InsertType insertType) {
                if (insertType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$1", "insertAddedComponents"));
                }
                List<NlComponent> added = this.components.stream().filter(component -> component.getParent() != this.layout).collect(Collectors.toList());
                this.editor.getModel().addComponents(added, this.layout, null, insertType);
            }
        };
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "createResizeHandler"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler", "createResizeHandler"));
        }
        NlComponent parent = component.getParent();
        if (parent == null) {
            return null;
        }
        final RelativeResizeHandler resizeHandler = new RelativeResizeHandler(editor, parent, component, horizontalEdgeType, verticalEdgeType);
        return new ResizeHandler(editor, this, component, horizontalEdgeType, verticalEdgeType){

            @Override
            @Nullable
            public String update(int x, int y, int modifiers, @NotNull Rectangle newBounds) {
                if (newBounds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBounds", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$2", "update"));
                }
                super.update(x, y, modifiers, newBounds);
                resizeHandler.updateResize(this.component, newBounds, modifiers);
                return null;
            }

            @Override
            public void commit(int px, int py, int modifiers, @NotNull Rectangle newBounds) {
                if (newBounds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBounds", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$2", "commit"));
                }
                resizeHandler.removeCycles();
                resizeHandler.applyConstraints(this.component);
            }

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                if (graphics == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$2", "paint"));
                }
                GuidelinePainter.paint(graphics, resizeHandler);
            }
        };
    }
}

