/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.annotations.NotNull;

public class OnClickEnumSupport
extends EnumSupport {
    public OnClickEnumSupport(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/OnClickEnumSupport", "<init>"));
        }
        super(property);
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        Collection<Object> classes;
        Module module = this.myProperty.getModel().getModule();
        Configuration configuration = this.myProperty.getModel().getConfiguration();
        String activityClassName = configuration.getActivity();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        if (activityClassName != null) {
            PsiClass activityClass;
            if (activityClassName.startsWith(".")) {
                MergedManifest manifest = MergedManifest.get(module);
                String pkg = StringUtil.notNullize((String)manifest.getPackage());
                activityClassName = pkg + activityClassName;
            }
            classes = (activityClass = facade.findClass(activityClassName, module.getModuleScope())) != null ? Collections.singletonList(activityClass) : Collections.emptyList();
        } else {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            PsiClass activityClass = facade.findClass("android.app.Activity", scope);
            classes = activityClass != null ? ClassInheritorsSearch.search((PsiClass)activityClass, (SearchScope)scope, (boolean)true).findAll() : Collections.emptyList();
        }
        ArrayList<ValueWithDisplayString> values = new ArrayList<ValueWithDisplayString>();
        HashSet<String> found = new HashSet<String>();
        for (PsiClass psiClass : classes) {
            for (PsiMethod method : psiClass.getAllMethods()) {
                if (!OnClickConverter.CONVERTER_FOR_LAYOUT.checkSignature(method) || !found.add(method.getName()) || !(method instanceof PsiMethodImpl)) continue;
                values.add(new ValueWithDisplayString(method.getName(), method.getName(), psiClass.getName()));
            }
        }
        ArrayList<ValueWithDisplayString> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/OnClickEnumSupport", "getAllValues"));
        }
        return arrayList;
    }
}

