/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class SetScrollViewSizeQuickFix
implements AndroidLintQuickFix {
    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/SetScrollViewSizeQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/SetScrollViewSizeQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/SetScrollViewSizeQuickFix", "apply"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return;
        }
        boolean isHorizontal = "HorizontalScrollView".equals(parentTag.getName());
        String attributeName = isHorizontal ? "layout_width" : "layout_height";
        tag.setAttribute(attributeName, "http://schemas.android.com/apk/res/android", "wrap_content");
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/SetScrollViewSizeQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/SetScrollViewSizeQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/inspections/lint/SetScrollViewSizeQuickFix", "isApplicable"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return false;
        }
        return tag.getParentTag() != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.set.to.wrap.content", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/SetScrollViewSizeQuickFix", "getName"));
        }
        return string;
    }
}

