/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenFoldersImporter {
    private final MavenProject myMavenProject;
    private final MavenImportingSettings myImportingSettings;
    private final MavenRootModelAdapter myModel;

    public static void updateProjectFolders(Project project, boolean updateTargetFoldersOnly) {
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        MavenImportingSettings settings = manager.getImportingSettings();
        WriteAction.run(() -> {
            ArrayList<ModifiableRootModel> rootModels = new ArrayList<ModifiableRootModel>();
            for (Module each : ModuleManager.getInstance((Project)project).getModules()) {
                MavenProject mavenProject = manager.findProject(each);
                if (mavenProject == null) continue;
                MavenRootModelAdapter a = new MavenRootModelAdapter(mavenProject, each, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project));
                new MavenFoldersImporter(mavenProject, settings, a).config(updateTargetFoldersOnly);
                ModifiableRootModel model = a.getRootModel();
                if (model.isChanged()) {
                    rootModels.add(model);
                    continue;
                }
                model.dispose();
            }
            if (!rootModels.isEmpty()) {
                ModifiableModelCommitter.multiCommit(rootModels, (ModifiableModuleModel)ModuleManager.getInstance((Project)((ModifiableRootModel)rootModels.get(0)).getProject()).getModifiableModel());
            }
        });
    }

    public MavenFoldersImporter(MavenProject mavenProject, MavenImportingSettings settings, MavenRootModelAdapter model) {
        this.myMavenProject = mavenProject;
        this.myImportingSettings = settings;
        this.myModel = model;
    }

    public void config() {
        this.config(false);
    }

    private void config(boolean updateTargetFoldersOnly) {
        if (!updateTargetFoldersOnly) {
            if (!this.myImportingSettings.isKeepSourceFolders()) {
                this.myModel.clearSourceFolders();
            }
            this.configSourceFolders();
            this.configOutputFolders();
        }
        this.configGeneratedFolders();
        if (!FileUtil.namesEqual((String)"pom", (String)this.myMavenProject.getFile().getNameWithoutExtension())) {
            this.generateNewContentRoots();
        }
        this.configExcludedFolders();
    }

    private void configSourceFolders() {
        LinkedMultiMap roots = new LinkedMultiMap();
        roots.putValues((Object)JavaSourceRootType.SOURCE, this.myMavenProject.getSources());
        roots.putValues((Object)JavaSourceRootType.TEST_SOURCE, this.myMavenProject.getTestSources());
        for (MavenImporter mavenImporter : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            mavenImporter.collectSourceRoots(this.myMavenProject, (arg_0, arg_1) -> MavenFoldersImporter.lambda$configSourceFolders$1((MultiMap)roots, arg_0, arg_1));
        }
        for (MavenResource mavenResource : this.myMavenProject.getResources()) {
            roots.putValue((Object)JavaResourceRootType.RESOURCE, (Object)mavenResource.getDirectory());
        }
        for (MavenResource mavenResource : this.myMavenProject.getTestResources()) {
            roots.putValue((Object)JavaResourceRootType.TEST_RESOURCE, (Object)mavenResource.getDirectory());
        }
        this.addBuilderHelperPaths("add-source", roots.getModifiable((Object)JavaSourceRootType.SOURCE));
        this.addBuilderHelperPaths("add-test-source", roots.getModifiable((Object)JavaSourceRootType.TEST_SOURCE));
        ArrayList<String> addedPaths = new ArrayList<String>();
        for (JpsModuleSourceRootType type : roots.keySet()) {
            for (String path : roots.get((Object)type)) {
                this.addSourceFolderIfNotOverlap(path, type, addedPaths);
            }
        }
    }

    private void addBuilderHelperPaths(String goal, Collection<String> folders) {
        Element sourcesElement;
        Element configurationElement = this.myMavenProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", goal);
        if (configurationElement != null && (sourcesElement = configurationElement.getChild("sources")) != null) {
            for (Element element : sourcesElement.getChildren()) {
                folders.add(element.getTextTrim());
            }
        }
    }

    private void addSourceFolderIfNotOverlap(String path, JpsModuleSourceRootType<?> type, List<String> addedPaths) {
        String canonicalPath = this.myModel.toPath(path).getPath();
        for (String existing : addedPaths) {
            if (!VfsUtilCore.isEqualOrAncestor((String)existing, (String)canonicalPath) && !VfsUtilCore.isEqualOrAncestor((String)canonicalPath, (String)existing)) continue;
            return;
        }
        addedPaths.add(canonicalPath);
        this.myModel.addSourceFolder(canonicalPath, type);
    }

    private void configOutputFolders() {
        String testOutputDirPath;
        String outputDirPath;
        String buildDirPath;
        if (this.myImportingSettings.isUseMavenOutput()) {
            this.myModel.useModuleOutput(this.myMavenProject.getOutputDirectory(), this.myMavenProject.getTestOutputDirectory());
        }
        if (!VfsUtilCore.isEqualOrAncestor((String)(buildDirPath = this.myModel.toPath(this.myMavenProject.getBuildDirectory()).getPath()), (String)(outputDirPath = this.myModel.toPath(this.myMavenProject.getOutputDirectory()).getPath()))) {
            this.myModel.addExcludedFolder(this.myMavenProject.getOutputDirectory());
        }
        if (!VfsUtilCore.isEqualOrAncestor((String)buildDirPath, (String)(testOutputDirPath = this.myModel.toPath(this.myMavenProject.getTestOutputDirectory()).getPath()))) {
            this.myModel.addExcludedFolder(this.myMavenProject.getTestOutputDirectory());
        }
    }

    private void configGeneratedFolders() {
        File[] targetChildren;
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        String generatedDir = this.myMavenProject.getGeneratedSourcesDirectory(false);
        String generatedDirTest = this.myMavenProject.getGeneratedSourcesDirectory(true);
        this.myModel.unregisterAll(targetDir.getPath(), false, false);
        if (this.myImportingSettings.getGeneratedSourcesFolder() != MavenImportingSettings.GeneratedSourcesFolder.IGNORE) {
            this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(true), JavaSourceRootType.TEST_SOURCE);
            this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(false), JavaSourceRootType.SOURCE);
        }
        if ((targetChildren = targetDir.listFiles()) != null) {
            for (File f : targetChildren) {
                if (!f.isDirectory()) continue;
                if (FileUtil.pathsEqual((String)generatedDir, (String)f.getPath())) {
                    this.configGeneratedSourceFolder(f, JavaSourceRootType.SOURCE);
                    continue;
                }
                if (!FileUtil.pathsEqual((String)generatedDirTest, (String)f.getPath())) continue;
                this.configGeneratedSourceFolder(f, JavaSourceRootType.TEST_SOURCE);
            }
        }
    }

    private void generateNewContentRoots() {
        ModifiableRootModel rootModel = this.myModel.getRootModel();
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            rootModel.removeContentEntry(contentEntry);
        }
        Object[] sourceRoots = this.myModel.getSourceRootUrls(true);
        ContainerUtil.sort((Object[])sourceRoots, FileUtil::comparePaths);
        HashSet topLevelSourceRoots = ContainerUtil.newHashSet();
        for (Object sourceRoot : sourceRoots) {
            if (!topLevelSourceRoots.stream().noneMatch(arg_0 -> MavenFoldersImporter.lambda$generateNewContentRoots$2((String)sourceRoot, arg_0))) continue;
            topLevelSourceRoots.add(sourceRoot);
        }
        for (String sourceRoot : topLevelSourceRoots) {
            rootModel.addContentEntry(sourceRoot);
        }
    }

    private void configExcludedFolders() {
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        String generatedDir = this.myMavenProject.getGeneratedSourcesDirectory(false);
        String generatedDirTest = this.myMavenProject.getGeneratedSourcesDirectory(true);
        File[] targetChildren = targetDir.listFiles();
        if (targetChildren != null) {
            for (File f : targetChildren) {
                if (!f.isDirectory() || FileUtil.pathsEqual((String)generatedDir, (String)f.getPath()) || FileUtil.pathsEqual((String)generatedDirTest, (String)f.getPath()) || !this.myImportingSettings.isExcludeTargetFolder() || this.myModel.hasRegisteredSourceSubfolder(f) || this.myModel.isAlreadyExcluded(f)) continue;
                this.myModel.addExcludedFolder(f.getPath());
            }
        }
        ArrayList<String> facetExcludes = new ArrayList<String>();
        for (MavenImporter each : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            each.collectExcludedFolders(this.myMavenProject, facetExcludes);
        }
        for (String eachFolder : facetExcludes) {
            this.myModel.unregisterAll(eachFolder, true, true);
            this.myModel.addExcludedFolder(eachFolder);
        }
        if (this.myImportingSettings.isExcludeTargetFolder()) {
            this.myModel.addExcludedFolder(targetDir.getPath());
        }
    }

    private void configGeneratedSourceFolder(@NotNull File targetDir, JavaSourceRootType rootType) {
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "org/jetbrains/idea/maven/importing/MavenFoldersImporter", "configGeneratedSourceFolder"));
        }
        switch (this.myImportingSettings.getGeneratedSourcesFolder()) {
            case GENERATED_SOURCE_FOLDER: {
                this.myModel.addGeneratedJavaSourceFolder(targetDir.getPath(), rootType);
                break;
            }
            case SUBFOLDER: {
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType);
                break;
            }
            case AUTODETECT: {
                Collection sourceRoots = JavaSourceRootDetectionUtil.suggestRoots((File)targetDir);
                for (JavaModuleSourceRoot root : sourceRoots) {
                    if (FileUtil.filesEqual((File)targetDir, (File)root.getDirectory())) {
                        this.myModel.addGeneratedJavaSourceFolder(targetDir.getPath(), rootType);
                        return;
                    }
                    this.addAsGeneratedSourceFolder(root.getDirectory(), rootType);
                }
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType);
                break;
            }
        }
    }

    private void addAsGeneratedSourceFolder(@NotNull File dir, JavaSourceRootType rootType) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/idea/maven/importing/MavenFoldersImporter", "addAsGeneratedSourceFolder"));
        }
        SourceFolder folder = this.myModel.getSourceFolder(dir);
        if (!this.myModel.hasRegisteredSourceSubfolder(dir) || folder != null && !MavenFoldersImporter.isGenerated(folder)) {
            this.myModel.addGeneratedJavaSourceFolder(dir.getPath(), rootType);
        }
    }

    private static boolean isGenerated(@NotNull SourceFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "org/jetbrains/idea/maven/importing/MavenFoldersImporter", "isGenerated"));
        }
        JavaSourceRootProperties properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
        return properties != null && properties.isForGeneratedSources();
    }

    private void addAllSubDirsAsGeneratedSources(@NotNull File dir, JavaSourceRootType rootType) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/idea/maven/importing/MavenFoldersImporter", "addAllSubDirsAsGeneratedSources"));
        }
        for (File f : MavenFoldersImporter.getChildren(dir)) {
            if (!f.isDirectory()) continue;
            this.addAsGeneratedSourceFolder(f, rootType);
        }
    }

    private static File[] getChildren(File dir) {
        File[] result = dir.listFiles();
        return result == null ? ArrayUtil.EMPTY_FILE_ARRAY : result;
    }

    private static /* synthetic */ boolean lambda$generateNewContentRoots$2(String sourceRoot, String root) {
        return FileUtil.isAncestor((String)root, (String)sourceRoot, (boolean)false);
    }

    private static /* synthetic */ void lambda$configSourceFolders$1(MultiMap roots, String s, JpsModuleSourceRootType type) {
        roots.putValue((Object)type, (Object)s);
    }
}

