/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.NullableConsumer;
import java.io.IOException;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class MavenShowEffectivePom
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(MavenShowEffectivePom.class);

    private static void showUnsupportedNotification(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom", "showUnsupportedNotification"));
        }
        new Notification("Maven", "Unsupported action", "<html>Maven3 required to use Show Effective POM action. \nPlease <a href='#'>select Maven3 home directory</a> or use \"Bundled (Maven 3)\"</html>", NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom$1", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom$1", "hyperlinkActivated"));
                }
                notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(project, "Maven");
            }
        }).notify(project);
    }

    public static void actionPerformed(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom", "actionPerformed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom", "actionPerformed"));
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        MavenProject mavenProject = manager.findProject(file);
        assert (mavenProject != null);
        manager.evaluateEffectivePom(mavenProject, (NullableConsumer<String>)((NullableConsumer)s -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom", "lambda$actionPerformed$1"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom", "lambda$null$0"));
                }
                if (project.isDisposed()) {
                    return;
                }
                if (s == null) {
                    new Notification("Maven", "Error", "Failed to evaluate effective pom.", NotificationType.ERROR).notify(project);
                    return;
                }
                String fileName = mavenProject.getMavenId().getArtifactId() + "-effective-pom.xml";
                PsiFile file1 = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (Language)XMLLanguage.INSTANCE, (CharSequence)s);
                try {
                    file1.getVirtualFile().setWritable(false);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                file1.navigate(true);
            });
        }));
    }

    @Nullable
    private static VirtualFile findPomXml(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom", "findPomXml"));
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        if (file.isDirectory() && (file = (VirtualFile)MavenUtil.streamPomFiles(MavenActionUtil.getProject(dataContext), file).findFirst().orElse(null)) == null) {
            return null;
        }
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(dataContext);
        if (manager == null) {
            return null;
        }
        MavenProject mavenProject = manager.findProject(file);
        if (mavenProject == null) {
            return null;
        }
        return file;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom", "actionPerformed"));
        }
        Project project = MavenActionUtil.getProject(event.getDataContext());
        if (project == null) {
            return;
        }
        VirtualFile file = MavenShowEffectivePom.findPomXml(event.getDataContext());
        if (file == null) {
            return;
        }
        if (MavenServerManager.getInstance().isUseMaven2()) {
            MavenShowEffectivePom.showUnsupportedNotification(project);
        } else {
            MavenShowEffectivePom.actionPerformed(project, file);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom", "update"));
        }
        Presentation p = e.getPresentation();
        boolean visible = MavenShowEffectivePom.findPomXml(e.getDataContext()) != null;
        p.setVisible(visible);
    }
}

