/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;

public class JavaFxBuiltInAttributeDescriptor
extends JavaFxPropertyAttributeDescriptor {
    private static final Logger LOG = Logger.getInstance(JavaFxBuiltInAttributeDescriptor.class);
    private final String myParentTagName;

    private JavaFxBuiltInAttributeDescriptor(String name, PsiClass psiClass) {
        super(name, psiClass);
        this.myParentTagName = null;
    }

    private JavaFxBuiltInAttributeDescriptor(String name, String parentTagName) {
        super(name, null);
        this.myParentTagName = parentTagName;
    }

    public static JavaFxBuiltInAttributeDescriptor create(String name, PsiClass psiClass) {
        if ("fx:id".equals(name)) {
            return new FxIdAttributeDescriptor(psiClass);
        }
        if ("fx:value".equals(name)) {
            return new FxValueAttributeDescriptor(psiClass);
        }
        if ("fx:constant".equals(name)) {
            return new FxConstantAttributeDescriptor(psiClass);
        }
        return new JavaFxBuiltInAttributeDescriptor(name, psiClass);
    }

    public static JavaFxBuiltInAttributeDescriptor create(String name, String parentTagName) {
        if ("fx:id".equals(name)) {
            return new FxIdAttributeDescriptor(parentTagName);
        }
        if ("fx:value".equals(name)) {
            return new FxValueAttributeDescriptor(parentTagName);
        }
        if ("fx:constant".equals(name)) {
            return new FxConstantAttributeDescriptor(parentTagName);
        }
        return new JavaFxBuiltInAttributeDescriptor(name, parentTagName);
    }

    @Override
    public boolean isEnumerated() {
        return false;
    }

    @Override
    public boolean isRequired() {
        if (this.myParentTagName == null) {
            return super.isRequired();
        }
        List<String> requiredAttrs = FxmlConstants.FX_BUILT_IN_TAG_REQUIRED_ATTRIBUTES.get(this.myParentTagName);
        return requiredAttrs != null && requiredAttrs.contains(this.getName());
    }

    @Override
    public String toString() {
        return this.myParentTagName != null ? this.myParentTagName + "#" + this.getName() : super.toString();
    }

    private static class FxConstantAttributeDescriptor
    extends JavaFxBuiltInAttributeDescriptor {
        private FxConstantAttributeDescriptor(PsiClass psiClass) {
            super("fx:constant", psiClass);
        }

        private FxConstantAttributeDescriptor(String parentTagName) {
            super("fx:constant", parentTagName);
        }

        @Override
        public boolean isEnumerated() {
            return this.getPsiClass() != null;
        }

        @Override
        protected PsiClass getEnum() {
            return this.getPsiClass();
        }

        @Override
        protected boolean isConstant(PsiField field) {
            return field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.hasModifierProperty("public");
        }

        @Override
        @Nullable
        protected String validateAttributeValue(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
            PsiField constField;
            if (xmlAttributeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxConstantAttributeDescriptor", "validateAttributeValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxConstantAttributeDescriptor", "validateAttributeValue"));
            }
            PsiClass tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue);
            if (!(tagClass == null || (constField = tagClass.findFieldByName(value, true)) != null && this.isConstant(constField))) {
                return "Constant '" + value + "' is not found";
            }
            return null;
        }
    }

    private static class FxValueAttributeDescriptor
    extends JavaFxBuiltInAttributeDescriptor {
        private FxValueAttributeDescriptor(PsiClass psiClass) {
            super("fx:value", psiClass);
        }

        private FxValueAttributeDescriptor(String parentTagName) {
            super("fx:value", parentTagName);
        }

        @Override
        public boolean isEnumerated() {
            PsiClass psiClass = this.getPsiClass();
            return psiClass != null && psiClass.isEnum();
        }

        @Override
        protected PsiClass getEnum() {
            PsiClass psiClass = this.getPsiClass();
            return psiClass.isEnum() ? psiClass : null;
        }

        @Override
        protected boolean isConstant(PsiField field) {
            return field instanceof PsiEnumConstant;
        }

        @Override
        @Nullable
        protected String validateAttributeValue(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
            if (xmlAttributeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxValueAttributeDescriptor", "validateAttributeValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxValueAttributeDescriptor", "validateAttributeValue"));
            }
            PsiClass tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue);
            if (tagClass != null) {
                if (tagClass.isEnum()) {
                    return JavaFxPsiUtil.validateEnumConstant(tagClass, value);
                }
                PsiMethod method = JavaFxPsiUtil.findValueOfMethod(tagClass);
                if (method == null) {
                    return "Unable to coerce '" + value + "' to " + tagClass.getQualifiedName() + ".";
                }
            }
            return FxValueAttributeDescriptor.validateLiteral(xmlAttributeValue, value);
        }
    }

    private static class FxIdAttributeDescriptor
    extends JavaFxBuiltInAttributeDescriptor {
        private FxIdAttributeDescriptor(PsiClass psiClass) {
            super("fx:id", psiClass);
        }

        private FxIdAttributeDescriptor(String parentTagName) {
            super("fx:id", parentTagName);
        }

        @Override
        public boolean hasIdType() {
            return true;
        }

        @Override
        @Nullable
        protected String validateAttributeValue(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
            PsiField field;
            PsiClass tagClass;
            if (xmlAttributeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxIdAttributeDescriptor", "validateAttributeValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInAttributeDescriptor$FxIdAttributeDescriptor", "validateAttributeValue"));
            }
            PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(xmlAttributeValue.getContainingFile());
            if (controllerClass != null && (tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue)) != null && (field = controllerClass.findFieldByName(value, true)) != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)tagClass, (PsiClass)PsiUtil.resolveClassInType((PsiType)field.getType()), (boolean)true)) {
                return "Cannot set " + tagClass.getQualifiedName() + " to field '" + field.getName() + "'";
            }
            return null;
        }
    }
}

